/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.NodeSetFirstGroupStep;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.store.StorePrepareIdSequence;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeFirstGroupStage
extends Stage {
    public static final String NAME = "Node --> Group";

    NodeFirstGroupStage(Configuration config, RecordStore<RelationshipGroupRecord> groupStore, NodeStore nodeStore, ByteArray cache, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator) {
        super(NAME, null, config, 0);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(groupStore, config), groupStore.getRecordSize()));
        this.add((Step)new ReadRecordsStep<RelationshipGroupRecord>(this.control(), config, true, groupStore, contextFactory));
        this.add((Step)new NodeSetFirstGroupStep(this.control(), config, nodeStore, cache, contextFactory));
        this.add((Step)new UpdateRecordsStep<NodeRecord>(this.control(), config, nodeStore, new StorePrepareIdSequence(), contextFactory, storeCursorsCreator, RecordCursorTypes.NODE_CURSOR));
    }
}

