/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.MetadataProvider;

public class ParallelBatchImporter
implements BatchImporter {
    private static final String BATCH_IMPORTER_CHECKPOINT = "Batch importer checkpoint.";
    private final RecordDatabaseLayout databaseLayout;
    private final FileSystemAbstraction fileSystem;
    private final PageCacheTracer pageCacheTracer;
    private final Configuration config;
    private final LogService logService;
    private final LogTailMetadata logTailMetadata;
    private final Config dbConfig;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final Monitor monitor;
    private final JobScheduler jobScheduler;
    private final Collector badCollector;
    private final LogFilesInitializer logFilesInitializer;
    private final IndexImporterFactory indexImporterFactory;
    private final MemoryTracker memoryTracker;
    private final CursorContextFactory contextFactory;

    public ParallelBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, LogTailMetadata logTailMetadata, Config dbConfig, Monitor monitor, JobScheduler jobScheduler, Collector badCollector, LogFilesInitializer logFilesInitializer, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, CursorContextFactory contextFactory) {
        this.databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
        this.fileSystem = fileSystem;
        this.pageCacheTracer = pageCacheTracer;
        this.config = config;
        this.logService = logService;
        this.logTailMetadata = logTailMetadata;
        this.dbConfig = dbConfig;
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
        this.monitor = monitor;
        this.jobScheduler = jobScheduler;
        this.badCollector = badCollector;
        this.logFilesInitializer = logFilesInitializer;
        this.indexImporterFactory = indexImporterFactory;
        this.memoryTracker = memoryTracker;
        this.contextFactory = contextFactory;
    }

    public void doImport(Input input) throws IOException {
        try (BatchingNeoStores store = ImportLogic.instantiateNeoStores(this.fileSystem, this.databaseLayout, this.pageCacheTracer, this.config, this.logService, this.additionalInitialIds, (LogTailLogVersionsMetadata)this.logTailMetadata, this.dbConfig, this.jobScheduler, this.memoryTracker, this.contextFactory);
             ImportLogic logic = new ImportLogic((DatabaseLayout)this.databaseLayout, store, this.config, this.dbConfig, this.logService, this.executionMonitor, this.badCollector, this.monitor, this.contextFactory, this.indexImporterFactory, this.pageCacheTracer, this.memoryTracker);){
            store.createNew();
            logic.initialize(input);
            logic.importNodes();
            logic.prepareIdMapper();
            logic.importRelationships();
            logic.calculateNodeDegrees();
            logic.linkRelationshipsOfAllTypes();
            logic.defragmentRelationshipGroups();
            this.logFilesInitializer.initializeLogFiles((DatabaseLayout)this.databaseLayout, (MetadataProvider)store.getNeoStores().getMetaDataStore(), new MetadataCache(this.logTailMetadata), this.fileSystem, BATCH_IMPORTER_CHECKPOINT);
            logic.buildAuxiliaryStores();
            logic.success();
        }
    }
}

