/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.RelationshipCountsProcessor;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ProcessRelationshipCountsDataStep
extends RecordProcessorStep<RelationshipRecord> {
    public ProcessRelationshipCountsDataStep(StageControl control, NodeLabelsCache cache, Configuration config, int highLabelId, int highRelationshipTypeId, CountsUpdater countsUpdater, NumberArrayFactory cacheFactory, ProgressReporter progressReporter, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator, MemoryTracker memoryTracker) {
        super(control, "COUNT", config, () -> new RelationshipCountsProcessor(cache, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, memoryTracker), true, ProcessRelationshipCountsDataStep.numberOfProcessors(config, cache, highLabelId, highRelationshipTypeId), contextFactory, storeCursorsCreator, new StatsProvider[0]);
    }

    private static int numberOfProcessors(Configuration config, NodeLabelsCache cache, int highLabelId, int highRelationshipTypeId) {
        GatheringMemoryStatsVisitor memVisitor = new GatheringMemoryStatsVisitor();
        cache.acceptMemoryStatsVisitor((MemoryStatsVisitor)memVisitor);
        long availableMem = config.maxOffHeapMemory() - memVisitor.getTotalUsage();
        long threadMem = RelationshipCountsProcessor.calculateMemoryUsage(highLabelId, highRelationshipTypeId);
        long possibleThreads = availableMem / threadMem;
        return possibleThreads >= (long)config.maxNumberOfWorkerThreads() ? 0 : Math.toIntExact(Math.max(1L, possibleThreads));
    }
}

