/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.ReadBehaviour;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.LenientStoreInput;
import org.neo4j.internal.batchimport.input.LenientStoreInputChunk;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

class LenientRelationshipReader
extends LenientStoreInputChunk {
    private final RelationshipStore relationshipStore;
    private final RelationshipRecord record;

    LenientRelationshipReader(ReadBehaviour readBehaviour, RelationshipStore relationshipStore, PropertyStore propertyStore, TokenHolders tokenHolders, CursorContextFactory contextFactory, StoreCursors storeCursors, Group group) {
        super(readBehaviour, propertyStore, tokenHolders, contextFactory, storeCursors, storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR), group);
        this.relationshipStore = relationshipStore;
        this.record = (RelationshipRecord)relationshipStore.newRecord();
    }

    @Override
    void readAndVisit(long id, InputEntityVisitor visitor, StoreCursors storeCursors) throws IOException {
        this.relationshipStore.getRecordByCursor(id, this.record, RecordLoad.LENIENT_CHECK, this.cursor);
        if (this.record.inUse()) {
            this.relationshipStore.ensureHeavy(this.record, storeCursors);
            int relationshipType = this.record.getType();
            String relationshipTypeName = LenientStoreInput.getTokenByIdSafe(this.tokenHolders.relationshipTypeTokens(), relationshipType).name();
            if (this.readBehaviour.shouldIncludeRelationship(relationshipTypeName)) {
                visitor.type(relationshipTypeName);
                visitor.startId((Object)this.record.getFirstNode(), this.group);
                visitor.endId((Object)this.record.getSecondNode(), this.group);
                this.visitPropertyChainNoThrow(visitor, this.record, EntityType.RELATIONSHIP, new String[]{relationshipTypeName});
                visitor.endOfEntity();
            }
        } else {
            this.readBehaviour.unused();
        }
    }

    @Override
    String recordType() {
        return "Relationship";
    }

    @Override
    boolean shouldIncludeProperty(ReadBehaviour readBehaviour, String key, String[] owningEntityTokens) {
        return readBehaviour.shouldIncludeRelationshipProperty(key, owningEntityTokens[0]);
    }
}

