/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.RecordDataAssembler;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<LongIterator> {
    public static final Monitor NO_MONITOR = id -> {};
    private final RecordStore<RECORD> store;
    private final int batchSize;
    private final Monitor monitor;
    private final RecordDataAssembler<RECORD> assembler;

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, CursorContextFactory contextFactory) {
        this(control, config, inRecordWritingStage, store, contextFactory, ReadRecordsStep.defaultAssembler(store), NO_MONITOR);
    }

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, CursorContextFactory contextFactory, RecordDataAssembler<RECORD> converter, Monitor monitor) {
        super(control, ">", config, ReadRecordsStep.parallelReading(config, inRecordWritingStage) ? Integer.min(12, config.maxNumberOfWorkerThreads()) : 1, contextFactory, new StatsProvider[0]);
        this.store = store;
        this.assembler = converter;
        this.batchSize = config.batchSize();
        this.monitor = monitor;
    }

    private static boolean parallelReading(Configuration config, boolean inRecordWritingStage) {
        return inRecordWritingStage && config.highIO() || !inRecordWritingStage && config.parallelRecordReads();
    }

    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees | 1);
    }

    protected void process(LongIterator idRange, BatchSender sender, CursorContext cursorContext) {
        if (!idRange.hasNext()) {
            return;
        }
        long id = idRange.next();
        AbstractBaseRecord[] batch = (AbstractBaseRecord[])this.control.reuse(() -> this.assembler.newBatchObject(this.batchSize));
        int i = 0;
        try (PageCursor cursor = this.store.openPageCursorForReading(id, cursorContext);){
            boolean hasNext = true;
            while (hasNext) {
                if (this.assembler.append(this.store, cursor, batch, id, i)) {
                    ++i;
                } else {
                    this.monitor.recordSkipped(id);
                }
                if (!(hasNext = idRange.hasNext())) continue;
                id = idRange.next();
            }
        }
        sender.send((Object)this.assembler.cutOffAt(batch, i));
    }

    public static <RECORD extends AbstractBaseRecord> RecordDataAssembler<RECORD> defaultAssembler(RecordStore<RECORD> store) {
        return new RecordDataAssembler<AbstractBaseRecord>(store::newRecord, true);
    }

    public static interface Monitor {
        public void recordSkipped(long var1);
    }
}

