/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.function.Function;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class Stages {
    public static <RECORD extends AbstractBaseRecord> Stage classicParallelStoreProcessingStage(final String name, final Configuration configuration, int orderingGuarantees, final RecordStore<RECORD> store, final ThrowingConsumer<RECORD, Throwable> processor, final RecordIdIterator ids, final boolean inWriteStage, final CursorContextFactory contextFactory) {
        return new Stage(name, null, configuration, orderingGuarantees){
            {
                super(name2, part, config, orderingGuarantees);
                this.add((Step)new BatchFeedStep(this.control(), configuration, ids, store.getRecordSize()));
                this.add((Step)new ReadRecordsStep(this.control(), configuration, inWriteStage, store, contextFactory));
                this.add((Step)new ProcessorStep<RECORD[]>(this.control(), name, configuration, 0, contextFactory, new StatsProvider[0]){

                    protected void process(RECORD[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
                        if (batch != null) {
                            for (Object record : batch) {
                                processor.accept(record);
                            }
                        }
                    }
                });
            }
        };
    }

    public static <RECORD extends AbstractBaseRecord> Stage classicParallelStoreUpdateStage(final String name, final Configuration configuration, int orderingGuarantees, final RecordStore<RECORD> store, final CursorType cursorType, final Function<CursorContext, StoreCursors> storeCursorsFunction, final PrepareIdSequence idSequence, final ThrowingConsumer<RECORD[], Throwable> processor, final RecordIdIterator ids, final boolean inWriteStage, final CursorContextFactory contextFactory) {
        return new Stage(name, null, configuration, orderingGuarantees){
            {
                super(name2, part, config, orderingGuarantees);
                this.add((Step)new BatchFeedStep(this.control(), configuration, ids, store.getRecordSize()));
                this.add((Step)new ReadRecordsStep(this.control(), configuration, inWriteStage, store, contextFactory));
                this.add((Step)new ProcessorStep<RECORD[]>(this.control(), name, configuration, 0, contextFactory, new StatsProvider[0]){

                    protected void process(RECORD[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
                        if (batch != null) {
                            processor.accept(batch);
                            sender.send(batch);
                        }
                    }
                });
                this.add((Step)new UpdateRecordsStep(this.control(), configuration, store, idSequence, contextFactory, storeCursorsFunction, cursorType));
            }
        };
    }
}

