/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.DirectRecordAccess;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DirectRecordAccessSet
implements RecordAccessSet,
AutoCloseable {
    private final DirectRecordAccess<NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<RelationshipGroupRecord, Integer> relationshipGroupRecords;
    private final DirectRecordAccess<PropertyKeyTokenRecord, Void> propertyKeyTokenRecords;
    private final DirectRecordAccess<RelationshipTypeTokenRecord, Void> relationshipTypeTokenRecords;
    private final DirectRecordAccess<LabelTokenRecord, Void> labelTokenRecords;
    private final DirectRecordAccess[] all;
    private final IdGeneratorFactory idGeneratorFactory;
    private final Loaders loaders;
    private final CachedStoreCursors storeCursors;

    public DirectRecordAccessSet(NeoStores neoStores, IdGeneratorFactory idGeneratorFactory, CursorContext cursorContext) {
        NodeStore nodeStore = neoStores.getNodeStore();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RelationshipGroupStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        RelationshipTypeTokenStore relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        LabelTokenStore labelTokenStore = neoStores.getLabelTokenStore();
        this.storeCursors = new CachedStoreCursors(neoStores, cursorContext);
        this.loaders = new Loaders(neoStores, (StoreCursors)this.storeCursors);
        this.nodeRecords = new DirectRecordAccess<NodeRecord, Void>(nodeStore, this.loaders.nodeLoader(), cursorContext, RecordCursorTypes.NODE_CURSOR, (StoreCursors)this.storeCursors);
        this.propertyRecords = new DirectRecordAccess<PropertyRecord, PrimitiveRecord>(propertyStore, this.loaders.propertyLoader(), cursorContext, RecordCursorTypes.PROPERTY_CURSOR, (StoreCursors)this.storeCursors);
        this.relationshipRecords = new DirectRecordAccess<RelationshipRecord, Void>(relationshipStore, this.loaders.relationshipLoader(), cursorContext, RecordCursorTypes.RELATIONSHIP_CURSOR, (StoreCursors)this.storeCursors);
        this.relationshipGroupRecords = new DirectRecordAccess<RelationshipGroupRecord, Integer>(relationshipGroupStore, this.loaders.relationshipGroupLoader(), cursorContext, RecordCursorTypes.GROUP_CURSOR, (StoreCursors)this.storeCursors);
        this.propertyKeyTokenRecords = new DirectRecordAccess<PropertyKeyTokenRecord, Void>(propertyKeyTokenStore, this.loaders.propertyKeyTokenLoader(), cursorContext, RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR, (StoreCursors)this.storeCursors);
        this.relationshipTypeTokenRecords = new DirectRecordAccess<RelationshipTypeTokenRecord, Void>(relationshipTypeTokenStore, this.loaders.relationshipTypeTokenLoader(), cursorContext, RecordCursorTypes.REL_TYPE_TOKEN_CURSOR, (StoreCursors)this.storeCursors);
        this.labelTokenRecords = new DirectRecordAccess<LabelTokenRecord, Void>(labelTokenStore, this.loaders.labelTokenLoader(), cursorContext, RecordCursorTypes.LABEL_TOKEN_CURSOR, (StoreCursors)this.storeCursors);
        this.all = new DirectRecordAccess[]{this.nodeRecords, this.propertyRecords, this.relationshipRecords, this.relationshipGroupRecords, this.propertyKeyTokenRecords, this.relationshipTypeTokenRecords, this.labelTokenRecords};
        this.idGeneratorFactory = idGeneratorFactory;
    }

    @Override
    public RecordAccess<NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException("Not needed. Implement if needed");
    }

    @Override
    public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenRecords;
    }

    @Override
    public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenRecords;
    }

    @Override
    public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenRecords;
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean markHighId) {
        for (DirectRecordAccess access : this.all) {
            access.commit();
        }
        if (markHighId) {
            this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
        }
    }

    @Override
    public int changeSize() {
        int total = 0;
        for (DirectRecordAccess access : this.all) {
            total += access.changeSize();
        }
        return total;
    }

    @Override
    public void close() {
        IOUtils.closeAllSilently((AutoCloseable[])new CachedStoreCursors[]{this.storeCursors});
    }
}

