/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenCreator;

public class DirectTokenCreator<R extends TokenRecord>
implements TokenCreator {
    private final NeoStores neoStores;
    private final TokenStore<R> store;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final IdGenerator storeIdGenerator;
    private final DynamicRecordAllocator dynamicRecordAllocator;

    public DirectTokenCreator(NeoStores neoStores, TokenStore<R> store, DynamicRecordAllocator dynamicRecordAllocator, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        this.neoStores = neoStores;
        this.store = store;
        this.storeIdGenerator = store.getIdGenerator();
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.dynamicRecordAllocator = dynamicRecordAllocator;
    }

    public int createToken(String name, boolean internal) throws KernelException {
        int keyId;
        try (CursorContext cursorContext = this.contextFactory.create("create token");
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);
             PageCursor cursor = this.store.openPageCursorForWriting(0L, cursorContext);){
            keyId = (int)this.storeIdGenerator.nextId(cursorContext);
            TokenRecord record = (TokenRecord)this.store.newRecord();
            record.setId(keyId);
            record.setInUse(true);
            record.setInternal(internal);
            record.setCreated();
            Collection<DynamicRecord> keyRecords = this.store.allocateNameRecords(PropertyStore.encodeString(name), this.dynamicRecordAllocator, cursorContext, this.memoryTracker);
            record.setNameId((int)((DynamicRecord)Iterables.first(keyRecords)).getId());
            record.addNameRecords(keyRecords);
            this.store.updateRecord(record, cursor, cursorContext, (StoreCursors)storeCursors);
        }
        return keyId;
    }

    public static TokenCreator directLabelTokenCreator(NeoStores neoStores, DynamicAllocatorProvider allocatorProvider, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        return new DirectTokenCreator<LabelTokenRecord>(neoStores, neoStores.getLabelTokenStore(), allocatorProvider.allocator(StoreType.LABEL_TOKEN_NAME), contextFactory, memoryTracker);
    }

    public static TokenCreator directPropertyKeyTokenCreator(NeoStores neoStores, DynamicAllocatorProvider allocatorProvider, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        return new DirectTokenCreator<PropertyKeyTokenRecord>(neoStores, neoStores.getPropertyKeyTokenStore(), allocatorProvider.allocator(StoreType.PROPERTY_KEY_TOKEN_NAME), contextFactory, memoryTracker);
    }

    public static TokenCreator directRelationshipTypeTokenCreator(NeoStores neoStores, DynamicAllocatorProvider allocatorProvider, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        return new DirectTokenCreator<RelationshipTypeTokenRecord>(neoStores, neoStores.getRelationshipTypeTokenStore(), allocatorProvider.allocator(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME), contextFactory, memoryTracker);
    }
}

