/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.RelationshipDirection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DirectionWrapper
extends Enum<DirectionWrapper> {
    public static final /* enum */ DirectionWrapper OUTGOING = new DirectionWrapper(RelationshipDirection.OUTGOING){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstOut();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstOut(firstNextRel);
        }

        @Override
        public boolean hasExternalDegrees(RelationshipGroupRecord group) {
            return group.hasExternalDegreesOut();
        }

        @Override
        public void setHasExternalDegrees(RelationshipGroupRecord group) {
            group.setHasExternalDegreesOut(true);
        }
    };
    public static final /* enum */ DirectionWrapper INCOMING = new DirectionWrapper(RelationshipDirection.INCOMING){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstIn();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstIn(firstNextRel);
        }

        @Override
        public boolean hasExternalDegrees(RelationshipGroupRecord group) {
            return group.hasExternalDegreesIn();
        }

        @Override
        public void setHasExternalDegrees(RelationshipGroupRecord group) {
            group.setHasExternalDegreesIn(true);
        }
    };
    public static final /* enum */ DirectionWrapper LOOP = new DirectionWrapper(RelationshipDirection.LOOP){

        @Override
        public long getNextRel(RelationshipGroupRecord group) {
            return group.getFirstLoop();
        }

        @Override
        public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
            group.setFirstLoop(firstNextRel);
        }

        @Override
        public boolean hasExternalDegrees(RelationshipGroupRecord group) {
            return group.hasExternalDegreesLoop();
        }

        @Override
        public void setHasExternalDegrees(RelationshipGroupRecord group) {
            group.setHasExternalDegreesLoop(true);
        }
    };
    private final RelationshipDirection direction;
    private static final /* synthetic */ DirectionWrapper[] $VALUES;

    public static DirectionWrapper[] values() {
        return (DirectionWrapper[])$VALUES.clone();
    }

    public static DirectionWrapper valueOf(String name) {
        return Enum.valueOf(DirectionWrapper.class, name);
    }

    private DirectionWrapper(RelationshipDirection direction) {
        this.direction = direction;
    }

    public abstract long getNextRel(RelationshipGroupRecord var1);

    public abstract void setNextRel(RelationshipGroupRecord var1, long var2);

    public abstract boolean hasExternalDegrees(RelationshipGroupRecord var1);

    public abstract void setHasExternalDegrees(RelationshipGroupRecord var1);

    public RelationshipDirection direction() {
        return this.direction;
    }

    public static DirectionWrapper wrapDirection(RelationshipRecord rel, NodeRecord startNode) {
        boolean isIn;
        boolean isOut = rel.getFirstNode() == startNode.getId();
        boolean bl = isIn = rel.getSecondNode() == startNode.getId();
        assert (isOut || isIn);
        if (isOut && isIn) {
            return LOOP;
        }
        return isOut ? OUTGOING : INCOMING;
    }

    public static DirectionWrapper from(Direction direction) {
        return direction == Direction.INCOMING ? INCOMING : (direction == Direction.OUTGOING ? OUTGOING : LOOP);
    }

    private static /* synthetic */ DirectionWrapper[] $values() {
        return new DirectionWrapper[]{OUTGOING, INCOMING, LOOP};
    }

    static {
        $VALUES = DirectionWrapper.$values();
    }
}

