/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.storageengine.api.CommandVersion;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class LockGuardedNeoStoreTransactionApplier
extends NeoStoreTransactionApplier {
    private final LockGroup lockGroup;
    private final LockService lockService;

    public LockGuardedNeoStoreTransactionApplier(CommandVersion version, NeoStores neoStores, CacheAccessBackDoor cacheAccess, LockService lockService, BatchContext batchContext, CursorContext cursorContext, StoreCursors storeCursors) {
        super(version, neoStores, cacheAccess, batchContext, cursorContext, storeCursors);
        this.lockGroup = batchContext.getLockGroup();
        this.lockService = lockService;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockType.EXCLUSIVE));
        return super.visitNodeCommand(command);
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getKey(), LockType.EXCLUSIVE));
        return super.visitRelationshipCommand(command);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (((PropertyRecord)command.after).isNodeSet()) {
            this.lockGroup.add(this.lockService.acquireNodeLock(command.getNodeId(), LockType.EXCLUSIVE));
        } else if (((PropertyRecord)command.after).isRelSet()) {
            this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getRelId(), LockType.EXCLUSIVE));
        } else if (((PropertyRecord)command.after).isSchemaSet()) {
            this.lockGroup.add(this.lockService.acquireCustomLock(4, command.getSchemaRuleId(), LockType.EXCLUSIVE));
        }
        return super.visitPropertyCommand(command);
    }
}

