/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.SimpleCountsStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

class MultiversionCountsStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final TransactionApplicationMode mode;
    private final CountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;

    MultiversionCountsStoreTransactionApplierFactory(TransactionApplicationMode mode, CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore) {
        this.mode = mode;
        this.countsStore = countsStore;
        this.groupDegreesStore = groupDegreesStore;
    }

    @Override
    public TransactionApplier startTx(CommandBatchToApply transaction, BatchContext batchContext) {
        return switch (this.mode) {
            case TransactionApplicationMode.REVERSE_RECOVERY -> new SimpleCountsStoreTransactionApplier(() -> this.countsStore.reverseRecoveryUpdater(transaction.transactionId(), transaction.cursorContext()), () -> this.groupDegreesStore.reverseRecoveryUpdater(transaction.transactionId(), transaction.cursorContext()));
            case TransactionApplicationMode.MVCC_ROLLBACK -> new SimpleCountsStoreTransactionApplier(() -> this.countsStore.rollbackUpdater(transaction.transactionId(), transaction.cursorContext()), () -> this.groupDegreesStore.rollbackUpdater(transaction.transactionId(), transaction.cursorContext()));
            default -> new SimpleCountsStoreTransactionApplier(() -> this.countsStore.updater(transaction.transactionId(), transaction.commandBatch().isLast(), transaction.cursorContext()), () -> this.groupDegreesStore.updater(transaction.transactionId(), transaction.commandBatch().isLast(), transaction.cursorContext()));
        };
    }
}

