/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Arrays;
import java.util.function.BooleanSupplier;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RelationshipConnection;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.util.VisibleForTesting;

final class RelationshipLockHelper {
    private RelationshipLockHelper() {
    }

    static void lockRelationshipsInOrder(RelationshipModifications.RelationshipBatch idsToLock, long optionalFirstInChain, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks, MemoryTracker memoryTracker) {
        int size = idsToLock.size();
        if (size == 1) {
            RelationshipLockHelper.lockSingleRelationship(idsToLock.first(), optionalFirstInChain, relRecords, locks);
        } else if (size > 1) {
            RelationshipLockHelper.lockMultipleRelationships(idsToLock, optionalFirstInChain, relRecords, locks, memoryTracker);
        }
    }

    static RecordAccess.RecordProxy<RelationshipRecord, Void> findAndLockInsertionPoint(long firstInChain, long nodeId, RecordAccess<RelationshipRecord, Void> relRecords, boolean multiVersioned, ResourceLocker locks, LockTracer lockTracer) {
        long nextRel = firstInChain;
        RecordAccess.RecordProxy<RelationshipRecord, Object> rBefore = null;
        if (!Record.isNull(nextRel)) {
            if (!multiVersioned) {
                while (!Record.isNull(nextRel)) {
                    boolean r1Locked = locks.tryExclusiveLock(ResourceType.RELATIONSHIP, nextRel);
                    RecordAccess.RecordProxy<RelationshipRecord, Object> r1 = relRecords.getOrLoad(nextRel, null, RecordLoad.ALWAYS);
                    RelationshipRecord r1Record = r1.forReadingLinkage();
                    if (!r1Locked || !r1Record.inUse()) {
                        nextRel = r1Record.getNextRel(nodeId);
                        if (!r1Locked) continue;
                        locks.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{r1.getKey()});
                        continue;
                    }
                    long r2Id = r1Record.getNextRel(nodeId);
                    if (!Record.isNull(r2Id)) {
                        boolean r2Locked = locks.tryExclusiveLock(ResourceType.RELATIONSHIP, r2Id);
                        RecordAccess.RecordProxy<RelationshipRecord, Object> r2 = relRecords.getOrLoad(r2Id, null, RecordLoad.ALWAYS);
                        RelationshipRecord r2Record = r2.forReadingLinkage();
                        if (!r2Locked || !r2Record.inUse()) {
                            nextRel = r2Record.getNextRel(nodeId);
                            locks.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{r1.getKey()});
                            if (!r2Locked) continue;
                            locks.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{r2.getKey()});
                            continue;
                        }
                    }
                    rBefore = r1;
                    break;
                }
            }
            if (rBefore == null) {
                locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, new long[]{firstInChain});
                RecordAccess.RecordProxy<RelationshipRecord, Object> firstProxy = relRecords.getOrLoad(firstInChain, null, RecordLoad.ALWAYS);
                long secondRel = firstProxy.forReadingLinkage().getNextRel(nodeId);
                if (!Record.isNull(secondRel)) {
                    locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, new long[]{secondRel});
                }
                rBefore = firstProxy;
            }
        }
        return rBefore;
    }

    private static void lockMultipleRelationships(RelationshipModifications.RelationshipBatch ids, long optionalFirstInChain, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks, MemoryTracker memoryTracker) {
        int upperLimitOfLocks = ids.size() * 5 + 1;
        try (MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();){
            HeapTrackingLongObjectHashMap optimistic = HeapTrackingCollections.newLongObjectMap((MemoryTracker)scopedMemoryTracker);
            scopedMemoryTracker.allocateHeap(HeapEstimator.sizeOfLongArray((int)upperLimitOfLocks));
            SortedLockList lockList = new SortedLockList(upperLimitOfLocks);
            lockList.add(optionalFirstInChain);
            ids.forEach((id, type, startNode, endNode, noProperties) -> {
                RelationshipRecord relationship = (RelationshipRecord)relRecords.getOrLoad(id, null).forReadingLinkage();
                optimistic.put(id, (Object)relationship);
                lockList.add(relationship.getId());
                lockList.add(RelationshipConnection.START_NEXT.get(relationship));
                lockList.add(RelationshipConnection.START_PREV.get(relationship));
                lockList.add(RelationshipConnection.END_NEXT.get(relationship));
                lockList.add(RelationshipConnection.END_PREV.get(relationship));
            });
            while (lockList.nextUnique()) {
                RelationshipRecord actual;
                long id2 = lockList.currentHighestLockedId();
                locks.acquireExclusive(LockTracer.NONE, ResourceType.RELATIONSHIP, new long[]{id2});
                RelationshipRecord old = (RelationshipRecord)optimistic.get(id2);
                if (old == null || !RelationshipLockHelper.recordHasLinkageChanges(old, actual = relRecords.getOrLoad(id2, null).forReadingLinkage())) continue;
                RelationshipLockHelper.rewindAndUnlockChanged(locks, lockList, old, actual);
                optimistic.put(id2, (Object)actual);
            }
        }
    }

    private static void rewindAndUnlockChanged(ResourceLocker locks, SortedLockList lockList, RelationshipRecord old, RelationshipRecord actual) {
        RelationshipLockHelper.rewindAndUnlockChanged(locks, RelationshipConnection.START_NEXT, lockList, old, actual);
        RelationshipLockHelper.rewindAndUnlockChanged(locks, RelationshipConnection.START_PREV, lockList, old, actual);
        RelationshipLockHelper.rewindAndUnlockChanged(locks, RelationshipConnection.END_NEXT, lockList, old, actual);
        RelationshipLockHelper.rewindAndUnlockChanged(locks, RelationshipConnection.END_PREV, lockList, old, actual);
    }

    private static void rewindAndUnlockChanged(ResourceLocker locks, RelationshipConnection connection, SortedLockList lockList, RelationshipRecord old, RelationshipRecord actual) {
        long actualConnectionId = connection.get(actual);
        long oldConnectionId = connection.get(old);
        if (oldConnectionId != actualConnectionId) {
            long currentHighestLockedId;
            boolean firstOccurrence;
            if (!Record.isNull(oldConnectionId)) {
                long currentHighestLockedId2 = lockList.validPosition() ? lockList.currentHighestLockedId() : Record.NULL_REFERENCE.longValue();
                boolean lastOccurrence = lockList.remove(oldConnectionId);
                if (lastOccurrence && oldConnectionId <= currentHighestLockedId2) {
                    locks.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{oldConnectionId});
                }
            }
            if (!Record.isNull(actualConnectionId) && (firstOccurrence = lockList.add(actualConnectionId)) && lockList.validPosition() && actualConnectionId < (currentHighestLockedId = lockList.currentHighestLockedId()) && !locks.tryExclusiveLock(ResourceType.RELATIONSHIP, actualConnectionId)) {
                do {
                    currentHighestLockedId = lockList.currentHighestLockedId();
                    locks.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{currentHighestLockedId});
                } while (lockList.prevUnique() && lockList.currentHighestLockedId() > actualConnectionId);
                lockList.prevUnique();
            }
        }
    }

    private static void lockSingleRelationship(long relId, long optionalFirstInChain, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks) {
        boolean retry;
        RelationshipRecord optimistic = relRecords.getOrLoad(relId, null).forReadingLinkage();
        assert (optimistic.inUse()) : optimistic.toString();
        long[] neighbours = new long[6];
        do {
            retry = false;
            neighbours[0] = optionalFirstInChain;
            neighbours[1] = relId;
            neighbours[2] = RelationshipConnection.START_NEXT.get(optimistic);
            neighbours[3] = RelationshipConnection.START_PREV.get(optimistic);
            neighbours[4] = RelationshipConnection.END_NEXT.get(optimistic);
            neighbours[5] = RelationshipConnection.END_PREV.get(optimistic);
            Arrays.sort(neighbours);
            RelationshipLockHelper.lockRelationshipsExclusively(locks, neighbours);
            RelationshipRecord actual = relRecords.getOrLoad(relId, null).forReadingLinkage();
            assert (actual.inUse());
            if (!RelationshipLockHelper.recordHasLinkageChanges(optimistic, actual)) continue;
            retry = true;
            RelationshipLockHelper.unlockRelationshipsExclusively(locks, neighbours);
            optimistic = actual;
        } while (retry);
    }

    private static boolean recordHasLinkageChanges(RelationshipRecord old, RelationshipRecord actual) {
        return RelationshipLockHelper.connectionHasChanged(RelationshipConnection.START_NEXT, old, actual) || RelationshipLockHelper.connectionHasChanged(RelationshipConnection.START_PREV, old, actual) || RelationshipLockHelper.connectionHasChanged(RelationshipConnection.END_NEXT, old, actual) || RelationshipLockHelper.connectionHasChanged(RelationshipConnection.END_PREV, old, actual);
    }

    private static boolean connectionHasChanged(RelationshipConnection connection, RelationshipRecord old, RelationshipRecord actual) {
        return connection.get(old) != connection.get(actual);
    }

    private static void lockRelationshipsExclusively(ResourceLocker locker, long[] ids) {
        long lastId = Record.NULL_REFERENCE.longValue();
        for (long id : ids) {
            if (id != lastId) {
                locker.acquireExclusive(LockTracer.NONE, ResourceType.RELATIONSHIP, new long[]{id});
            }
            lastId = id;
        }
    }

    private static void unlockRelationshipsExclusively(ResourceLocker locker, long[] ids) {
        long lastId = Record.NULL_REFERENCE.longValue();
        for (long id : ids) {
            if (id != lastId) {
                locker.releaseExclusive(ResourceType.RELATIONSHIP, new long[]{id});
            }
            lastId = id;
        }
    }

    static class SortedLockList {
        private final MutableLongList list;
        private int index = -1;

        SortedLockList(int initialCapacity) {
            this.list = LongLists.mutable.withInitialCapacity(initialCapacity);
        }

        boolean add(long l) {
            if (l != Record.NULL_REFERENCE.longValue()) {
                boolean existed;
                int insertIndex = this.list.binarySearch(l);
                boolean bl = existed = insertIndex >= 0;
                if (insertIndex < 0) {
                    insertIndex = -insertIndex - 1;
                }
                if (insertIndex <= this.index) {
                    ++this.index;
                }
                this.list.addAtIndex(insertIndex, l);
                return !existed;
            }
            return true;
        }

        boolean remove(long l) {
            if (!Record.isNull(l)) {
                boolean unique;
                int removeIndex = this.list.binarySearch(l);
                assert (removeIndex >= 0) : l + " did not exist";
                this.list.removeAtIndex(removeIndex);
                boolean bl = unique = !(this.list.size() > removeIndex && this.list.get(removeIndex) == l || removeIndex > 0 && this.list.get(removeIndex - 1) == l);
                if (removeIndex < this.index) {
                    --this.index;
                } else if (removeIndex == this.index && (unique || this.index == this.list.size() || l != this.list.get(this.index))) {
                    --this.index;
                }
                this.index = Math.min(this.index, this.list.size() - 1);
                return unique;
            }
            return true;
        }

        long currentHighestLockedId() {
            return this.list.get(this.index);
        }

        boolean next() {
            if (this.list.size() > 0 && this.index < this.list.size()) {
                ++this.index;
                return this.index < this.list.size();
            }
            return false;
        }

        boolean nextUnique() {
            return this.unique(this::next);
        }

        boolean prev() {
            if (this.index >= 0) {
                --this.index;
                return this.index >= 0;
            }
            return false;
        }

        boolean prevUnique() {
            return this.unique(this::prev);
        }

        private boolean unique(BooleanSupplier traverser) {
            if (!this.validPosition()) {
                return traverser.getAsBoolean();
            }
            long old = this.currentHighestLockedId();
            while (traverser.getAsBoolean()) {
                if (this.currentHighestLockedId() == old) continue;
                return true;
            }
            return false;
        }

        boolean validPosition() {
            return this.index >= 0 && this.index < this.list.size();
        }

        @VisibleForTesting
        LongList underlyingList() {
            return this.list;
        }
    }
}

