/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.recordstorage.PropertyBasedSchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.SchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaStorage
implements SchemaRuleAccess {
    private final SchemaStore schemaStore;
    private final TokenHolders tokenHolders;

    public SchemaStorage(SchemaStore schemaStore, TokenHolders tokenHolders) {
        this.schemaStore = schemaStore;
        this.tokenHolders = tokenHolders;
    }

    @Override
    public long newRuleId(CursorContext cursorContext) {
        return this.schemaStore.getIdGenerator().nextId(cursorContext);
    }

    @Override
    public Iterable<SchemaRule> getAll(StoreCursors storeCursors) {
        return this.streamAllSchemaRules(false, storeCursors)::iterator;
    }

    @Override
    public Iterable<SchemaRule> getAllIgnoreMalformed(StoreCursors storeCursors) {
        return this.streamAllSchemaRules(true, storeCursors)::iterator;
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        SchemaRecord record = this.loadSchemaRecord(ruleId, storeCursors);
        return this.readSchemaRule(record, storeCursors);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).iterator();
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAllIgnoreMalformed(StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(true, storeCursors)).iterator();
    }

    @Override
    public IndexDescriptor[] indexGetForSchema(SchemaDescriptorSupplier supplier, StoreCursors storeCursors) {
        SchemaDescriptor schema = supplier.schema();
        return (IndexDescriptor[])SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).filter(rule -> rule.schema().equals(schema)).toArray(IndexDescriptor[]::new);
    }

    @Override
    public IndexDescriptor indexGetForName(String indexName, StoreCursors storeCursors) {
        return SchemaStorage.indexRules(this.streamAllSchemaRules(false, storeCursors)).filter(idx -> idx.getName().equals(indexName)).findAny().orElse(null);
    }

    @Override
    public ConstraintDescriptor constraintsGetSingle(ConstraintDescriptor descriptor, StoreCursors storeCursors) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        ConstraintDescriptor[] rules = (ConstraintDescriptor[])SchemaStorage.constraintRules(this.streamAllSchemaRules(false, storeCursors)).filter(descriptor::equals).toArray(ConstraintDescriptor[]::new);
        if (rules.length == 0) {
            throw new SchemaRuleNotFoundException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        if (rules.length > 1) {
            throw new DuplicateSchemaRuleException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        return rules[0];
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAllIgnoreMalformed(StoreCursors storeCursors) {
        return SchemaStorage.constraintRules(this.streamAllSchemaRules(true, storeCursors)).iterator();
    }

    @Override
    public SchemaRecordChangeTranslator getSchemaRecordChangeTranslator() {
        return new PropertyBasedSchemaRecordChangeTranslator(){

            @Override
            protected IntObjectMap<Value> asMap(SchemaRule rule) throws KernelException {
                return SchemaStore.convertSchemaRuleToMap(rule, SchemaStorage.this.tokenHolders);
            }

            @Override
            protected void setConstraintIndexOwnerProperty(long constraintId, IntObjectProcedure<Value> proc) throws KernelException {
                int propertyId = SchemaStore.getOwningConstraintPropertyKeyId(SchemaStorage.this.tokenHolders);
                proc.value(propertyId, (Object)Values.longValue((long)constraintId));
            }
        };
    }

    @Override
    public void writeSchemaRule(SchemaRule rule, IdUpdateListener idUpdateListener, DynamicAllocatorProvider allocationProvider, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) throws KernelException {
        IntObjectMap<Value> protoProperties = SchemaStore.convertSchemaRuleToMap(rule, this.tokenHolders);
        PropertyStore propertyStore = this.schemaStore.propertyStore();
        ArrayList blocks = new ArrayList();
        protoProperties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue(block, keyId, value, allocationProvider.allocator(StoreType.PROPERTY_STRING), allocationProvider.allocator(StoreType.PROPERTY_ARRAY), cursorContext, memoryTracker);
            blocks.add(block);
        });
        assert (!blocks.isEmpty()) : "Property blocks should have been produced for schema rule: " + rule;
        long nextPropId = Record.NO_NEXT_PROPERTY.longValue();
        PropertyRecord currRecord = SchemaStorage.newInitialisedPropertyRecord(propertyStore, rule, cursorContext);
        try (PageCursor propertyCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
             PageCursor schemaCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR);){
            for (PropertyBlock block : blocks) {
                if (!currRecord.hasSpaceFor(block)) {
                    PropertyRecord nextRecord = SchemaStorage.newInitialisedPropertyRecord(propertyStore, rule, cursorContext);
                    SchemaStorage.linkAndWritePropertyRecord(propertyStore, currRecord, idUpdateListener, nextRecord.getId(), nextPropId, propertyCursor, cursorContext, storeCursors);
                    nextPropId = currRecord.getId();
                    currRecord = nextRecord;
                }
                currRecord.addPropertyBlock(block);
            }
            SchemaStorage.linkAndWritePropertyRecord(propertyStore, currRecord, idUpdateListener, Record.NO_PREVIOUS_PROPERTY.longValue(), nextPropId, propertyCursor, cursorContext, storeCursors);
            nextPropId = currRecord.getId();
            SchemaRecord schemaRecord = (SchemaRecord)this.schemaStore.newRecord();
            schemaRecord.initialize(true, nextPropId);
            schemaRecord.setId(rule.getId());
            schemaRecord.setCreated();
            this.schemaStore.updateRecord(schemaRecord, idUpdateListener, schemaCursor, cursorContext, storeCursors);
            long highId = rule.getId();
            this.schemaStore.getIdGenerator().setHighestPossibleIdInUse(highId);
        }
    }

    @Override
    public void deleteSchemaRule(long ruleId, IdUpdateListener idUpdateListener, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) throws KernelException {
        SchemaRecord schemaRecord = this.loadSchemaRecord(ruleId, storeCursors);
        PropertyStore propertyStore = this.schemaStore.propertyStore();
        PropertyRecord propRecord = propertyStore.newRecord();
        long nextProp = schemaRecord.getNextProp();
        try (PageCursor propertyCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);){
            while (nextProp != Record.NO_NEXT_PROPERTY.longValue()) {
                try {
                    propertyStore.getRecordByCursor(nextProp, propRecord, RecordLoad.NORMAL, propertyCursor);
                    propertyStore.ensureHeavy(propRecord, storeCursors);
                }
                catch (InvalidRecordException e) {
                    throw new MalformedSchemaRuleException("Cannot read schema rule because it is referencing a property record (id " + nextProp + ") that is invalid: " + propRecord, (Throwable)((Object)e));
                }
                nextProp = propRecord.getNextProp();
                SchemaStorage.deletePropertyRecord(propertyStore, propRecord, idUpdateListener, propertyCursor, cursorContext, storeCursors);
            }
        }
        try (PageCursor schemaCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR);){
            schemaRecord.setId(ruleId);
            schemaRecord.initialize(false, Record.NO_NEXT_PROPERTY.longValue());
            this.schemaStore.updateRecord(schemaRecord, idUpdateListener, schemaCursor, cursorContext, storeCursors);
        }
    }

    private static PropertyRecord newInitialisedPropertyRecord(PropertyStore propertyStore, SchemaRule rule, CursorContext cursorContext) {
        PropertyRecord record = propertyStore.newRecord();
        record.setId(propertyStore.getIdGenerator().nextId(cursorContext));
        record.setSchemaRuleId(rule.getId());
        record.setCreated();
        return record;
    }

    private static void linkAndWritePropertyRecord(PropertyStore propertyStore, PropertyRecord record, IdUpdateListener idUpdateListener, long prevPropId, long nextProp, PageCursor propertyCursor, CursorContext cursorContext, StoreCursors storeCursors) {
        record.setInUse(true);
        record.setPrevProp(prevPropId);
        record.setNextProp(nextProp);
        propertyStore.updateRecord(record, idUpdateListener, propertyCursor, cursorContext, storeCursors);
        long highId = record.getId();
        propertyStore.getIdGenerator().setHighestPossibleIdInUse(highId);
    }

    private static void deletePropertyRecord(PropertyStore propertyStore, PropertyRecord record, IdUpdateListener idUpdateListener, PageCursor propertyCursor, CursorContext cursorContext, StoreCursors storeCursors) {
        PropertyDeleter.deletePropertyRecordIncludingValueRecords(record);
        record.setPrevProp(Record.NO_NEXT_PROPERTY.longValue());
        record.setNextProp(Record.NO_NEXT_PROPERTY.longValue());
        propertyStore.updateRecord(record, idUpdateListener, propertyCursor, cursorContext, storeCursors);
    }

    private SchemaRecord loadSchemaRecord(long ruleId, StoreCursors storeCursors) {
        return this.schemaStore.getRecordByCursor(ruleId, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR));
    }

    @VisibleForTesting
    Stream<SchemaRule> streamAllSchemaRules(boolean ignoreMalformed, StoreCursors storeCursors) {
        long startId = this.schemaStore.getNumberOfReservedLowIds();
        long endId = this.schemaStore.getIdGenerator().getHighId();
        return LongStream.range(startId, endId).mapToObj(id -> this.schemaStore.getRecordByCursor(id, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.LENIENT_ALWAYS, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR))).filter(AbstractBaseRecord::inUse).flatMap(record -> this.readSchemaRuleThrowingRuntimeException((SchemaRecord)record, ignoreMalformed, storeCursors));
    }

    private static Stream<IndexDescriptor> indexRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof IndexDescriptor).map(rule -> (IndexDescriptor)rule);
    }

    private static Stream<ConstraintDescriptor> constraintRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof ConstraintDescriptor).map(rule -> (ConstraintDescriptor)rule);
    }

    private Stream<SchemaRule> readSchemaRuleThrowingRuntimeException(SchemaRecord record, boolean ignoreMalformed, StoreCursors storeCursors) {
        try {
            return Stream.of(this.readSchemaRule(record, storeCursors));
        }
        catch (MalformedSchemaRuleException e) {
            if (!ignoreMalformed && this.schemaStore.isInUse(record.getId(), storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR))) {
                throw new RuntimeException(e);
            }
            return Stream.empty();
        }
    }

    private SchemaRule readSchemaRule(SchemaRecord record, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        return SchemaStore.readSchemaRule(record, this.schemaStore.propertyStore(), this.tokenHolders, storeCursors);
    }
}

