/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.Supplier;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;

class SimpleCountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final Supplier<CountsUpdater> counstUpdaterSupplier;
    private final Supplier<DegreeUpdater> degreeUpdaterSupplier;
    private CountsUpdater countsUpdater;
    private DegreeUpdater degreesUpdater;

    SimpleCountsStoreTransactionApplier(Supplier<CountsUpdater> countsUpdaterSupplier, Supplier<DegreeUpdater> degreeUpdaterSupplier) {
        this.counstUpdaterSupplier = countsUpdaterSupplier;
        this.degreeUpdaterSupplier = degreeUpdaterSupplier;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.countsUpdater().incrementNodeCount((long)command.labelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        this.countsUpdater().incrementRelationshipCount((long)command.startLabelId(), command.typeId(), (long)command.endLabelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        this.degreesUpdater().increment(command.groupId(), command.direction(), command.delta());
        return false;
    }

    @Override
    public void close() {
        if (this.countsUpdater != null) {
            this.countsUpdater.close();
        }
        if (this.degreesUpdater != null) {
            this.degreesUpdater.close();
        }
    }

    private CountsUpdater countsUpdater() {
        if (this.countsUpdater == null) {
            this.countsUpdater = this.counstUpdaterSupplier.get();
        }
        return this.countsUpdater;
    }

    private DegreeUpdater degreesUpdater() {
        if (this.degreesUpdater == null) {
            this.degreesUpdater = this.degreeUpdaterSupplier.get();
        }
        return this.degreesUpdater;
    }
}

