/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.List;
import org.neo4j.internal.recordstorage.DirectTokenCreator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

public class StoreTokens {
    private StoreTokens() {
    }

    public static TokensLoader allReadableTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(StoreCursors storeCursors) {
                return neoStores.getPropertyKeyTokenStore().getAllReadableTokens(storeCursors);
            }

            public List<NamedToken> getLabelTokens(StoreCursors storeCursors) {
                return neoStores.getLabelTokenStore().getAllReadableTokens(storeCursors);
            }

            public List<NamedToken> getRelationshipTypeTokens(StoreCursors storeCursors) {
                return neoStores.getRelationshipTypeTokenStore().getAllReadableTokens(storeCursors);
            }
        };
    }

    public static TokensLoader allTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(StoreCursors storeCursors) {
                return neoStores.getPropertyKeyTokenStore().getTokens(storeCursors);
            }

            public List<NamedToken> getLabelTokens(StoreCursors storeCursors) {
                return neoStores.getLabelTokenStore().getTokens(storeCursors);
            }

            public List<NamedToken> getRelationshipTypeTokens(StoreCursors storeCursors) {
                return neoStores.getRelationshipTypeTokenStore().getTokens(storeCursors);
            }
        };
    }

    public static TokenHolders readOnlyTokenHolders(NeoStores neoStores, StoreCursors storeCursors) {
        TokenHolder propertyKeyTokens = StoreTokens.createReadOnlyTokenHolder("PropertyKey");
        TokenHolder labelTokens = StoreTokens.createReadOnlyTokenHolder("Label");
        TokenHolder relationshipTypeTokens = StoreTokens.createReadOnlyTokenHolder("RelationshipType");
        TokenHolders tokenHolders = new TokenHolders(propertyKeyTokens, labelTokens, relationshipTypeTokens);
        tokenHolders.setInitialTokens(StoreTokens.allReadableTokens(neoStores), storeCursors);
        return tokenHolders;
    }

    public static TokenHolder createReadOnlyTokenHolder(String tokenType) {
        return new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), tokenType);
    }

    public static TokenHolders directTokenHolders(NeoStores neoStores, DynamicAllocatorProvider allocatorProvider, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder(DirectTokenCreator.directPropertyKeyTokenCreator(neoStores, allocatorProvider, contextFactory, memoryTracker), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder(DirectTokenCreator.directLabelTokenCreator(neoStores, allocatorProvider, contextFactory, memoryTracker), "Label"), (TokenHolder)new DelegatingTokenHolder(DirectTokenCreator.directRelationshipTypeTokenCreator(neoStores, allocatorProvider, contextFactory, memoryTracker), "RelationshipType"));
        try (CursorContext cursorContext = contextFactory.create("load tokens");
             CachedStoreCursors storeCursors = new CachedStoreCursors(neoStores, cursorContext);){
            tokenHolders.propertyKeyTokens().setInitialTokens(neoStores.getPropertyKeyTokenStore().getTokens((StoreCursors)storeCursors));
            tokenHolders.labelTokens().setInitialTokens(neoStores.getLabelTokenStore().getTokens((StoreCursors)storeCursors));
            tokenHolders.relationshipTypeTokens().setInitialTokens(neoStores.getRelationshipTypeTokenStore().getTokens((StoreCursors)storeCursors));
        }
        return tokenHolders;
    }
}

