/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.id;

import java.util.Arrays;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.internal.recordstorage.id.IdSequenceProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;

public class BatchedTransactionIdSequenceProvider
implements IdSequenceProvider {
    private final NeoStores neoStores;
    private final BatchedIdSequence[] transactionSequences = new BatchedIdSequence[StoreType.STORE_TYPES.length];

    public BatchedTransactionIdSequenceProvider(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    @Override
    public IdSequence getIdSequence(StoreType storeType) {
        return this.getOrCreateSequence(storeType);
    }

    private IdSequence getOrCreateSequence(StoreType storeType) {
        BatchedIdSequence newSequence;
        int typeIndex = storeType.ordinal();
        BatchedIdSequence sequence = this.transactionSequences[typeIndex];
        if (sequence != null) {
            return sequence;
        }
        this.transactionSequences[typeIndex] = newSequence = new BatchedIdSequence(storeType);
        return newSequence;
    }

    @Override
    public void release(CursorContext cursorContext) {
        for (BatchedIdSequence batchedIdSequence : this.transactionSequences) {
            if (batchedIdSequence == null) continue;
            batchedIdSequence.close(cursorContext);
        }
        Arrays.fill(this.transactionSequences, null);
    }

    private class BatchedIdSequence
    implements IdSequence {
        private final int recordsPerPage;
        private PageIdRange range = PageIdRange.EMPTY;
        private final IdGenerator idGenerator;

        public BatchedIdSequence(StoreType storeType) {
            RecordStore store = BatchedTransactionIdSequenceProvider.this.neoStores.getRecordStore(storeType);
            this.idGenerator = store.getIdGenerator();
            this.recordsPerPage = store.getRecordsPerPage();
        }

        public long nextId(CursorContext cursorContext) {
            if (!this.range.hasNext()) {
                this.close(cursorContext);
                this.range = this.idGenerator.nextPageRange(cursorContext, this.recordsPerPage);
            }
            return this.range.nextId();
        }

        public void close(CursorContext cursorContext) {
            if (this.range == PageIdRange.EMPTY) {
                return;
            }
            this.idGenerator.releasePageRange(this.range, cursorContext);
        }
    }
}

