/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.txstate.validation.TransactionConflictException;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidationResource;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;

public class TransactionCommandValidator
implements CommandVisitor,
TransactionValidator {
    private static final int PAGE_ID_BITS = 54;
    private static final long PAGE_ID_MASK = 0x3FFFFFFFFFFFFFL;
    private final NeoStores neoStores;
    private final LockManager.Client validationLockClient;
    private final MemoryTracker memoryTracker;
    private final Config config;
    private final PageCursor[] validationCursors;
    private final Log log;
    private EnumMap<StoreType, MutableLongSet> checkedPages;
    private LockTracer lockTracer;
    private CursorContext cursorContext;
    private boolean dumpLocks;
    private Map<PageEntry, Long> observedPageVersions;

    public TransactionCommandValidator(NeoStores neoStores, LockManager lockManager, MemoryTracker memoryTracker, Config config, LogProvider logProvider) {
        this.neoStores = neoStores;
        this.validationLockClient = lockManager.newClient();
        this.memoryTracker = memoryTracker;
        this.config = config;
        this.validationCursors = new PageCursor[StoreType.STORE_TYPES.length];
        this.checkedPages = new EnumMap(StoreType.class);
        this.log = logProvider.getLog(this.getClass());
    }

    public TransactionValidationResource validate(Collection<StorageCommand> commands, long transactionSequenceNumber, CursorContext cursorContext, LeaseClient leaseClient, LockTracer lockTracer) {
        try {
            if (commands.isEmpty()) {
                TransactionValidationResource transactionValidationResource = TransactionValidationResource.EMPTY_VALIDATION_RESOURCE;
                return transactionValidationResource;
            }
            this.initValidation(transactionSequenceNumber, cursorContext, leaseClient, lockTracer);
            cursorContext.getVersionContext().resetObsoleteHeadState();
            for (StorageCommand command : commands) {
                ((Command)command).handle(this);
            }
            TransactionValidationResource closeLocksResult = () -> ((LockManager.Client)this.validationLockClient).close();
            TransactionValidationResource transactionValidationResource = this.dumpLocks ? new DumpStateResourceWrapper((Resource)closeLocksResult, this.validationLockClient, this.log, this.neoStores, this.observedPageVersions) : closeLocksResult;
            return transactionValidationResource;
        }
        catch (TransactionConflictException tce) {
            this.validationLockClient.close();
            throw tce;
        }
        catch (Exception e) {
            this.validationLockClient.close();
            throw new TransactionConflictException(e);
        }
        finally {
            this.closeCursors();
        }
    }

    private void initValidation(long txSequenceNumber, CursorContext cursorContext, LeaseClient leaseClient, LockTracer lockTracer) {
        this.cursorContext = cursorContext;
        this.lockTracer = lockTracer;
        this.dumpLocks = (Boolean)this.config.get(GraphDatabaseInternalSettings.multi_version_dump_transaction_validation_page_locks);
        this.observedPageVersions = this.dumpLocks ? new HashMap() : Collections.emptyMap();
        this.validationLockClient.initialize(leaseClient, txSequenceNumber, this.memoryTracker, this.config);
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.checkStore(((NodeRecord)command.getAfter()).getId(), this.getCursor(StoreType.NODE), StoreType.NODE);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.checkStore(((RelationshipRecord)command.getAfter()).getId(), this.getCursor(StoreType.RELATIONSHIP), StoreType.RELATIONSHIP);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord propertyRecord = (PropertyRecord)command.getAfter();
        this.checkStore(propertyRecord.getId(), this.getCursor(StoreType.PROPERTY), StoreType.PROPERTY);
        if (propertyRecord.inUse()) {
            for (PropertyBlock block : propertyRecord) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.checkDynamicRecords(block.getValueRecords());
            }
        }
        this.checkDynamicRecords(propertyRecord.getDeletedRecords());
        return false;
    }

    private void checkDynamicRecords(List<DynamicRecord> records) throws IOException {
        PageCursor stringCursor = null;
        PageCursor arrayCursor = null;
        for (DynamicRecord valueRecord : records) {
            PropertyType recordType = valueRecord.getType();
            if (recordType == PropertyType.STRING) {
                if (stringCursor == null) {
                    stringCursor = this.getCursor(StoreType.PROPERTY_STRING);
                }
                this.checkStore(valueRecord.getId(), stringCursor, StoreType.PROPERTY_STRING);
                continue;
            }
            if (recordType == PropertyType.ARRAY) {
                if (arrayCursor == null) {
                    arrayCursor = this.getCursor(StoreType.PROPERTY_ARRAY);
                }
                this.checkStore(valueRecord.getId(), arrayCursor, StoreType.PROPERTY_ARRAY);
                continue;
            }
            throw new InvalidRecordException("Not supported record type for validation: " + valueRecord);
        }
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.checkStore(((RelationshipGroupRecord)command.getAfter()).getId(), this.getCursor(StoreType.RELATIONSHIP_GROUP), StoreType.RELATIONSHIP_GROUP);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        this.checkStore(((SchemaRecord)command.getAfter()).getId(), this.getCursor(StoreType.SCHEMA), StoreType.SCHEMA);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        return false;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        return false;
    }

    @Override
    public boolean visitMetaDataCommand(Command.MetaDataCommand command) {
        return false;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        return false;
    }

    private PageCursor getCursor(StoreType storeType) {
        PageCursor cursor = this.validationCursors[storeType.ordinal()];
        if (cursor != null) {
            return cursor;
        }
        this.validationCursors[storeType.ordinal()] = cursor = this.neoStores.getRecordStore(storeType).openPageCursorForReadingHeadOnly(0L, this.cursorContext);
        return cursor;
    }

    private void closeCursors() {
        this.checkedPages = new EnumMap(StoreType.class);
        for (int i = 0; i < this.validationCursors.length; ++i) {
            PageCursor cursor = this.validationCursors[i];
            if (cursor == null) continue;
            cursor.close();
        }
        Arrays.fill(this.validationCursors, null);
    }

    private void checkStore(long recordId, PageCursor pageCursor, StoreType storeType) throws IOException {
        long pageId;
        MutableLongSet checkedStorePages = this.checkedPages.get((Object)storeType);
        if (checkedStorePages == null) {
            checkedStorePages = LongSets.mutable.empty();
            this.checkedPages.put(storeType, checkedStorePages);
        }
        if (checkedStorePages.contains(pageId = RecordPageLocationCalculator.pageIdForRecord(recordId, this.neoStores.getRecordStore(storeType).getRecordsPerPage()))) {
            return;
        }
        this.validationLockClient.acquireExclusive(this.lockTracer, ResourceType.PAGE, new long[]{pageId | (long)storeType.ordinal() << 54});
        VersionContext versionContext = this.cursorContext.getVersionContext();
        if (pageCursor.next(pageId) && versionContext.invisibleHeadObserved()) {
            throw new TransactionConflictException((DatabaseFile)storeType.getDatabaseFile(), versionContext);
        }
        checkedStorePages.add(pageId);
        if (this.dumpLocks) {
            this.storyPageInfo(storeType, pageId, versionContext);
        }
    }

    private void storyPageInfo(StoreType storeType, long pageId, VersionContext versionContext) {
        long chainHead = versionContext.chainHeadVersion();
        this.observedPageVersions.put(new PageEntry(pageId, storeType), chainHead);
    }

    private static class DumpStateResourceWrapper
    implements TransactionValidationResource {
        private static final long UNKNOWN_PAGE_VERSION = -1L;
        private final Resource delegate;
        private final LockManager.Client lockClient;
        private final Log log;
        private final NeoStores neoStores;
        private int chunkNumber;
        private long txId;
        private final Map<PageEntry, Long> observedVersions;

        private DumpStateResourceWrapper(Resource delegate, LockManager.Client lockClient, Log log, NeoStores neoStores, Map<PageEntry, Long> observedVersions) {
            this.delegate = delegate;
            this.lockClient = lockClient;
            this.log = log;
            this.neoStores = neoStores;
            this.observedVersions = observedVersions;
        }

        public void close() {
            this.dumpLockedPagesInfo();
            this.delegate.close();
        }

        private void dumpLockedPagesInfo() {
            StringBuilder locksDumpBuilder = new StringBuilder();
            locksDumpBuilder.append("Transaction sequence number: ").append(this.lockClient.getTransactionId()).append(" with tx id(chunk): ").append(this.txId).append("(").append(this.chunkNumber).append(")");
            Collection locks = this.lockClient.activeLocks();
            if (locks.isEmpty()) {
                locksDumpBuilder.append(" does not have any validation page locks.");
            } else {
                locksDumpBuilder.append(" locked page(s):").append(System.lineSeparator());
                EnumMap<StoreType, Integer> storyTypeRecords = new EnumMap<StoreType, Integer>(StoreType.class);
                for (ActiveLock activeLock : locks) {
                    long resourceId = activeLock.resourceId();
                    StoreType storeType = StoreType.values()[(int)(resourceId >> 54)];
                    int recordsPerPage = storyTypeRecords.computeIfAbsent(storeType, type -> this.neoStores.getRecordStore((StoreType)((Object)type)).getRecordsPerPage());
                    long pageId = resourceId & 0x3FFFFFFFFFFFFFL;
                    locksDumpBuilder.append(pageId).append(" of ").append((Object)storeType).append(" store, with records per page ").append(recordsPerPage).append(" observed page version: ").append(this.observedVersions.getOrDefault(new PageEntry(pageId, storeType), -1L)).append(System.lineSeparator());
                }
            }
            this.log.error(locksDumpBuilder.toString());
        }

        public void chunkAppended(int chunkNumber, long txId) {
            this.chunkNumber = chunkNumber;
            this.txId = txId;
        }
    }

    private record PageEntry(long id, StoreType type) {
    }
}

