/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import org.neo4j.configuration.Config;
import org.neo4j.internal.recordstorage.validation.TransactionCommandValidator;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.time.SystemNanoClock;

public class TransactionCommandValidatorFactory
implements TransactionValidatorFactory {
    private final NeoStores neoStores;
    private final LogProvider logProvider;
    private final LockManager lockManager;
    private final Config config;

    public TransactionCommandValidatorFactory(NeoStores neoStores, StorageEngineFactory storageEngineFactory, Config config, SystemNanoClock clock, LogProvider logProvider) {
        this.neoStores = neoStores;
        this.logProvider = logProvider;
        this.lockManager = storageEngineFactory.createLockManager(config, clock);
        this.config = config;
    }

    public TransactionValidator createTransactionValidator(MemoryTracker memoryTracker) {
        return new TransactionCommandValidator(this.neoStores, this.lockManager, memoryTracker, this.config, this.logProvider);
    }

    public void close() throws Exception {
        this.lockManager.close();
    }
}

