/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public abstract class AbstractDynamicStore
extends CommonAbstractStore<DynamicRecord, IntStoreHeader> {
    public AbstractDynamicStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, String typeDescriptor, int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, conf, idType, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, typeDescriptor, recordFormat, new DynamicStoreHeaderFormat(dataSizeFromConfiguration, recordFormat), readOnly, databaseName, openOptions);
    }

    public static void allocateRecordsFromBytes(Collection<DynamicRecord> recordList, byte[] src, DynamicRecordAllocator dynamicRecordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        Objects.requireNonNull(src);
        int dataSize = dynamicRecordAllocator.getRecordDataSize();
        int payloadSize = src.length;
        int lastBlockSize = payloadSize % dataSize;
        long fullBlockSize = DynamicRecord.SHALLOW_SIZE + HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + dataSize));
        int numberOfFullBlocks = payloadSize / dataSize;
        long totalSize = (long)numberOfFullBlocks * fullBlockSize;
        if (lastBlockSize != 0) {
            totalSize += DynamicRecord.SHALLOW_SIZE + HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + lastBlockSize));
        }
        memoryTracker.allocateHeap(totalSize);
        DynamicRecord nextRecord = dynamicRecordAllocator.nextRecord(cursorContext);
        int srcOffset = 0;
        do {
            DynamicRecord record = nextRecord;
            record.setStartRecord(srcOffset == 0);
            if (payloadSize - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextRecord = dynamicRecordAllocator.nextRecord(cursorContext);
                record.setNextBlock(nextRecord.getId());
                srcOffset += dataSize;
            } else {
                data = new byte[payloadSize - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextRecord = null;
                record.setNextBlock(Record.NO_NEXT_BLOCK.intValue());
            }
            recordList.add(record);
            assert (record.getData() != null);
        } while (nextRecord != null);
    }

    public static HeavyRecordData readFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        int offset;
        byte[] header = null;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        int totalSize = 0;
        int i = 0;
        for (DynamicRecord record : records) {
            offset = 0;
            if (i++ == 0) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
        }
        byte[] bArray = new byte[totalSize];
        assert (header != null) : "header should be non-null since records should not be empty: " + Iterables.toString(records, (String)", ");
        int sourceOffset = header.length;
        offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return new HeavyRecordData(header, bArray);
    }

    @Override
    public String toString() {
        return super.toString() + "[fileName:" + this.storageFile.getFileName() + ", blockSize:" + this.getRecordDataSize() + "]";
    }

    HeavyRecordData readFullByteArray(Iterable<DynamicRecord> records, PropertyType propertyType, StoreCursors storeCursors) {
        for (DynamicRecord record : records) {
            this.ensureHeavy(record, storeCursors);
        }
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType);
    }

    private static class DynamicStoreHeaderFormat
    extends IntStoreHeaderFormat {
        DynamicStoreHeaderFormat(int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat) {
            super(dataSizeFromConfiguration + recordFormat.getRecordHeaderSize());
        }

        @Override
        public void writeHeader(PageCursor cursor) {
            if (this.header < 1 || this.header > 65535) {
                throw new IllegalArgumentException("Illegal block size[" + this.header + "], limit is 65535");
            }
            super.writeHeader(cursor);
        }
    }

    record HeavyRecordData(byte[] header, byte[] data) {
    }
}

