/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.api.StoreId;

public class NeoStores
implements AutoCloseable {
    private static final String ID_USAGE_LOGGER_TAG = "idUsageLogger";
    private static final String STORE_ALREADY_CLOSED_MESSAGE = "Specified store was already closed.";
    private static final String STORE_NOT_INITIALIZED_TEMPLATE = "Specified store was not initialized. Please specify %s as one of the stores types that should be open to be able to use it.";
    private final FileSystemAbstraction fileSystem;
    private final RecordDatabaseLayout layout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final InternalLogProvider logProvider;
    private final CursorContextFactory contextFactory;
    private final StoreType[] initializedStores;
    private final RecordFormats recordFormats;
    private final CommonAbstractStore[] stores;
    private final LogTailLogVersionsMetadata logTailMetadata;
    private final ImmutableSet<OpenOption> openOptions;
    private final boolean readOnly;
    private final InternalLog log;

    NeoStores(FileSystemAbstraction fileSystem, RecordDatabaseLayout layout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, RecordFormats recordFormats, CursorContextFactory contextFactory, boolean readOnly, LogTailLogVersionsMetadata logTailMetadata, StoreType[] storeTypes, ImmutableSet<OpenOption> openOptions) {
        this.fileSystem = fileSystem;
        this.layout = layout;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.pageCacheTracer = pageCacheTracer;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.recordFormats = recordFormats;
        this.contextFactory = contextFactory;
        this.readOnly = readOnly;
        this.logTailMetadata = logTailMetadata;
        this.openOptions = openOptions;
        this.stores = new CommonAbstractStore[StoreType.STORE_TYPES.length];
        try {
            for (StoreType type : storeTypes) {
                this.getOrOpenStore(type);
            }
        }
        catch (RuntimeException initException) {
            try {
                this.close();
            }
            catch (RuntimeException closeException) {
                initException.addSuppressed(closeException);
            }
            throw initException;
        }
        this.initializedStores = storeTypes;
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        for (StoreType type : StoreType.STORE_TYPES) {
            try {
                this.closeStore(type);
            }
            catch (RuntimeException t) {
                ex = (RuntimeException)Exceptions.chain(ex, (Throwable)t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void closeStore(StoreType type) {
        int i = type.ordinal();
        if (this.stores[i] != null) {
            try {
                this.stores[i].close();
            }
            finally {
                this.stores[i] = null;
            }
        }
    }

    public void flush(DatabaseFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        this.pageCache.flushAndForce(flushEvent);
        this.checkpoint(flushEvent, cursorContext);
    }

    public void checkpoint(DatabaseFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        this.visitStores(store -> {
            this.log.debug("Checkpointing %s", new Object[]{store.storageFile.getFileName()});
            try (FileFlushEvent fileFlushEvent = flushEvent.beginFileFlush();){
                store.getIdGenerator().checkpoint(fileFlushEvent, cursorContext);
            }
        });
    }

    private CommonAbstractStore openStore(StoreType type) {
        CommonAbstractStore store;
        int storeIndex = type.ordinal();
        this.stores[storeIndex] = store = type.open(this);
        return store;
    }

    private <T extends CommonAbstractStore> T initialize(T store, CursorContextFactory contextFactory) {
        store.initialise(contextFactory);
        return store;
    }

    private CommonAbstractStore getStore(StoreType storeType) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            String message = ArrayUtils.contains((Object[])this.initializedStores, (Object)((Object)storeType)) ? STORE_ALREADY_CLOSED_MESSAGE : String.format(STORE_NOT_INITIALIZED_TEMPLATE, storeType.name());
            throw new IllegalStateException(message);
        }
        return store;
    }

    private CommonAbstractStore getOrOpenStore(StoreType storeType) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            store = this.openStore(storeType);
        }
        return store;
    }

    public MetaDataStore getMetaDataStore() {
        return (MetaDataStore)this.getStore(StoreType.META_DATA);
    }

    public NodeStore getNodeStore() {
        return (NodeStore)this.getStore(StoreType.NODE);
    }

    public RelationshipStore getRelationshipStore() {
        return (RelationshipStore)this.getStore(StoreType.RELATIONSHIP);
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return (RelationshipTypeTokenStore)this.getStore(StoreType.RELATIONSHIP_TYPE_TOKEN);
    }

    public LabelTokenStore getLabelTokenStore() {
        return (LabelTokenStore)this.getStore(StoreType.LABEL_TOKEN);
    }

    public PropertyStore getPropertyStore() {
        return (PropertyStore)this.getStore(StoreType.PROPERTY);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return (PropertyKeyTokenStore)this.getStore(StoreType.PROPERTY_KEY_TOKEN);
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return (RelationshipGroupStore)this.getStore(StoreType.RELATIONSHIP_GROUP);
    }

    public SchemaStore getSchemaStore() {
        return (SchemaStore)this.getStore(StoreType.SCHEMA);
    }

    public void start(CursorContext cursorContext) throws IOException {
        this.start(store -> {}, cursorContext);
    }

    public void start(Consumer<CommonAbstractStore<?, ?>> listener, CursorContext cursorContext) throws IOException {
        this.visitStores(store -> {
            store.start(cursorContext);
            listener.accept((CommonAbstractStore<?, ?>)store);
        });
    }

    public void verifyStoreOk() {
        this.visitStores(CommonAbstractStore::checkStoreOk);
    }

    public void logIdUsage(DiagnosticsLogger msgLog) {
        try (CursorContext cursorContext = this.contextFactory.create(ID_USAGE_LOGGER_TAG);){
            this.visitStores(store -> store.logIdUsage(msgLog, cursorContext));
        }
    }

    private <E extends Exception> void visitStores(ThrowingConsumer<CommonAbstractStore, E> visitor) throws E {
        for (CommonAbstractStore store : this.stores) {
            if (store == null) continue;
            visitor.accept((Object)store);
        }
    }

    CommonAbstractStore createNodeStore() {
        return this.initialize(new NodeStore(this.fileSystem, this.layout.nodeStore(), this.layout.idNodeStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (DynamicArrayStore)this.getOrOpenStore(StoreType.NODE_LABEL), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createNodeLabelStore() {
        return this.createDynamicArrayStore(this.layout.nodeLabelStore(), this.layout.idNodeLabelStore(), RecordIdType.NODE_LABELS, (Setting<Integer>)GraphDatabaseInternalSettings.label_block_size);
    }

    CommonAbstractStore createPropertyKeyTokenStore() {
        return this.initialize(new PropertyKeyTokenStore(this.fileSystem, this.layout.propertyKeyTokenStore(), this.layout.idPropertyKeyTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN_NAME), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createPropertyKeyTokenNamesStore() {
        return this.createDynamicStringStore(this.layout.propertyKeyTokenNamesStore(), this.layout.idPropertyKeyTokenNamesStore(), RecordIdType.PROPERTY_KEY_TOKEN_NAME, 30);
    }

    CommonAbstractStore createPropertyStore() {
        return this.initialize(new PropertyStore(this.fileSystem, this.layout.propertyStore(), this.layout.idPropertyStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_STRING), (PropertyKeyTokenStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN), (DynamicArrayStore)this.getOrOpenStore(StoreType.PROPERTY_ARRAY), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createPropertyStringStore() {
        return this.createDynamicStringStore(this.layout.propertyStringStore(), this.layout.idPropertyStringStore());
    }

    CommonAbstractStore createPropertyArrayStore() {
        return this.createDynamicArrayStore(this.layout.propertyArrayStore(), this.layout.idPropertyArrayStore(), RecordIdType.ARRAY_BLOCK, (Setting<Integer>)GraphDatabaseInternalSettings.array_block_size);
    }

    CommonAbstractStore createRelationshipStore() {
        return this.initialize(new RelationshipStore(this.fileSystem, this.layout.relationshipStore(), this.layout.idRelationshipStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createRelationshipTypeTokenStore() {
        return this.initialize(new RelationshipTypeTokenStore(this.fileSystem, this.layout.relationshipTypeTokenStore(), this.layout.idRelationshipTypeTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createRelationshipTypeTokenNamesStore() {
        return this.createDynamicStringStore(this.layout.relationshipTypeTokenNamesStore(), this.layout.idRelationshipTypeTokenNamesStore(), RecordIdType.RELATIONSHIP_TYPE_TOKEN_NAME, 30);
    }

    CommonAbstractStore createLabelTokenStore() {
        return this.initialize(new LabelTokenStore(this.fileSystem, this.layout.labelTokenStore(), this.layout.idLabelTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.LABEL_TOKEN_NAME), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createSchemaStore() {
        return this.initialize(new SchemaStore(this.fileSystem, this.layout.schemaStore(), this.layout.idSchemaStore(), this.config, (IdType)SchemaIdType.SCHEMA, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, (PropertyStore)this.getOrOpenStore(StoreType.PROPERTY), this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createRelationshipGroupStore() {
        return this.initialize(new RelationshipGroupStore(this.fileSystem, this.layout.relationshipGroupStore(), this.layout.idRelationshipGroupStore(), this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    CommonAbstractStore createLabelTokenNamesStore() {
        return this.createDynamicStringStore(this.layout.labelTokenNamesStore(), this.layout.idLabelTokenNamesStore(), RecordIdType.LABEL_TOKEN_NAME, 30);
    }

    CommonAbstractStore createMetadataStore() {
        return this.initialize(new MetaDataStore(this.fileSystem, this.layout.metadataStore(), this.config, this.pageCache, this.pageCacheTracer, this.logProvider, this.recordFormats.metaData(), this.readOnly, this.logTailMetadata, this.layout.getDatabaseName(), this.openOptions, () -> StoreId.generateNew((String)"record", (String)this.recordFormats.getFormatFamily().name(), (int)this.recordFormats.majorVersion(), (int)this.recordFormats.minorVersion())), this.contextFactory);
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile) {
        return this.createDynamicStringStore(storeFile, idFile, RecordIdType.STRING_BLOCK, (Integer)this.config.get(GraphDatabaseInternalSettings.string_block_size));
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile, RecordIdType idType, int blockSize) {
        return this.initialize(new DynamicStringStore(this.fileSystem, storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, blockSize, this.recordFormats.dynamic(), this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    private CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, RecordIdType idType, Setting<Integer> blockSizeProperty) {
        return this.createDynamicArrayStore(storeFile, idFile, idType, (Integer)this.config.get(blockSizeProperty));
    }

    CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, RecordIdType idType, int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size of dynamic array store should be positive integer.");
        }
        return this.initialize(new DynamicArrayStore(this.fileSystem, storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, blockSize, this.recordFormats, this.readOnly, this.layout.getDatabaseName(), this.openOptions), this.contextFactory);
    }

    public <RECORD extends AbstractBaseRecord> RecordStore<RECORD> getRecordStore(StoreType type) {
        return this.getStore(type);
    }

    public RecordFormats getRecordFormats() {
        return this.recordFormats;
    }

    public ImmutableSet<OpenOption> getOpenOptions() {
        return this.openOptions;
    }

    public static boolean isStorePresent(FileSystemAbstraction fs, RecordDatabaseLayout databaseLayout) {
        return fs.fileExists(databaseLayout.pathForExistsMarker());
    }

    public long estimateAvailableReservedSpace() throws IOException {
        MutableLong bytes = new MutableLong();
        this.visitStores(store -> bytes.add(store.estimateAvailableReservedSpace()));
        return bytes.longValue();
    }
}

