/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordSubscriber;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;

public interface RecordStore<RECORD extends AbstractBaseRecord> {
    public Path getStorageFile();

    public IdGenerator getIdGenerator();

    public long getHighestPossibleIdInUse(CursorContext var1);

    public int getNumberOfReservedLowIds();

    public int getStoreHeaderInt();

    public RECORD newRecord();

    public PageCursor openPageCursorForReading(long var1, CursorContext var3);

    public PageCursor openPageCursorForReadingHeadOnly(long var1, CursorContext var3);

    public PageCursor openPageCursorForReadingWithPrefetching(long var1, CursorContext var3);

    public PageCursor openPageCursorForWriting(long var1, CursorContext var3);

    public RECORD getRecordByCursor(long var1, RECORD var3, RecordLoad var4, PageCursor var5) throws InvalidRecordException;

    public void nextRecordByCursor(RECORD var1, RecordLoad var2, PageCursor var3) throws InvalidRecordException;

    public void ensureHeavy(RECORD var1, StoreCursors var2);

    public List<RECORD> getRecords(long var1, RecordLoad var3, boolean var4, PageCursor var5) throws InvalidRecordException;

    public void streamRecords(long var1, RecordLoad var3, boolean var4, PageCursor var5, RecordSubscriber<RECORD> var6);

    public void updateRecord(RECORD var1, IdUpdateListener var2, PageCursor var3, CursorContext var4, StoreCursors var5);

    default public void updateRecord(RECORD record, PageCursor cursor, CursorContext cursorContext, StoreCursors storeCursors) {
        this.updateRecord(record, IdUpdateListener.DIRECT, cursor, cursorContext, storeCursors);
    }

    public int getRecordSize();

    public int getRecordDataSize();

    public int getRecordsPerPage();

    public void close();

    public void flush(FileFlushEvent var1, CursorContext var2);

    public void prepareForCommit(RECORD var1, IdSequence var2, CursorContext var3);

    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> var1, PageCursor var2) throws EXCEPTION;

    public void allocate(long var1) throws IOException;

    public long estimateAvailableReservedSpace() throws IOException;
}

