/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.LegacyMetadataHandler;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.aligned.PageAligned;
import org.neo4j.kernel.impl.store.format.aligned.PageAlignedV4_3;
import org.neo4j.kernel.impl.store.format.aligned.PageAlignedV5_0;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV4_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV5_0;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public class RecordFormatSelector {
    private static final String STORE_SELECTION_TAG = "storeSelection";
    private static final RecordFormats DEFAULT_FORMAT = PageAligned.LATEST_RECORD_FORMATS;
    private static final List<RecordFormats> KNOWN_FORMATS = Arrays.asList(StandardV4_3.RECORD_FORMATS, StandardV5_0.RECORD_FORMATS, PageAlignedV4_3.RECORD_FORMATS, PageAlignedV5_0.RECORD_FORMATS);

    private RecordFormatSelector() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static RecordFormats defaultFormat() {
        return RecordFormatSelector.defaultFormat(false);
    }

    private static RecordFormats defaultFormat(boolean includeDevFormats) {
        return includeDevFormats ? RecordFormatSelector.findLatestFormatInFamily(DEFAULT_FORMAT, true).orElse(DEFAULT_FORMAT) : DEFAULT_FORMAT;
    }

    public static Optional<RecordFormats> selectForStoreVersionIdentifier(StoreVersionIdentifier storeVersionIdentifier) {
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(format -> format.majorVersion() == storeVersionIdentifier.getMajorVersion() && format.minorVersion() == storeVersionIdentifier.getMinorVersion() && format.getFormatFamily().name().equals(storeVersionIdentifier.getFormatName())).findAny();
    }

    public static RecordFormats selectForStore(RecordDatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        Path neoStoreFile = databaseLayout.metadataStore();
        if (fs.fileExists(neoStoreFile)) {
            RecordFormats recordFormats;
            block9: {
                CursorContext cursorContext = contextFactory.create(STORE_SELECTION_TAG);
                try {
                    MetaDataStore.FieldAccess filedAccess = MetaDataStore.getFieldAccess(pageCache, neoStoreFile, databaseLayout.getDatabaseName(), cursorContext);
                    StoreId storeId = filedAccess.isLegacyFieldValid() ? filedAccess.readStoreId() : LegacyMetadataHandler.readMetadata44FromStore(pageCache, databaseLayout.metadataStore(), databaseLayout.getDatabaseName(), cursorContext).storeId();
                    recordFormats = RecordFormatSelector.selectForStoreVersionIdentifier((StoreVersionIdentifier)storeId).map(format -> {
                        RecordFormatSelector.info(logProvider, "Selected " + format + " record format from store " + databaseLayout.databaseDirectory());
                        return format;
                    }).orElse(null);
                    if (cursorContext == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (cursorContext != null) {
                            try {
                                cursorContext.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        RecordFormatSelector.info(logProvider, String.format("Unable to read format for store %s. %s ", databaseLayout.databaseDirectory(), e.getMessage()));
                    }
                }
                cursorContext.close();
            }
            return recordFormats;
        }
        return null;
    }

    public static RecordFormats selectForStoreOrConfigForNewDbs(Config config, RecordDatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        RecordFormats currentFormat = RecordFormatSelector.selectForStore(databaseLayout, fs, pageCache, logProvider, contextFactory);
        if (currentFormat != null) {
            RecordFormatSelector.info(logProvider, String.format("Selected format from the store files: %s", currentFormat));
            return currentFormat;
        }
        RecordFormats configuredFormat = RecordFormatSelector.getConfiguredRecordFormatNewDb(config, (DatabaseLayout)databaseLayout);
        if (configuredFormat != null) {
            RecordFormatSelector.info(logProvider, String.format("Selected configured format for store %s: %s", databaseLayout.databaseDirectory(), configuredFormat));
            return configuredFormat;
        }
        return RecordFormatSelector.defaultFormat((Boolean)config.get(GraphDatabaseInternalSettings.include_versions_under_development));
    }

    private static RecordFormats getConfiguredRecordFormatNewDb(Config config, DatabaseLayout databaseLayout) {
        if ("system".equals(databaseLayout.getDatabaseName())) {
            return null;
        }
        boolean includeDevFormats = (Boolean)config.get(GraphDatabaseInternalSettings.include_versions_under_development);
        RecordFormats formats = RecordFormatSelector.loadRecordFormat((String)config.get(GraphDatabaseSettings.db_format), includeDevFormats);
        if (includeDevFormats && formats != null) {
            Optional<RecordFormats> newestFormatInFamily = RecordFormatSelector.findLatestFormatInFamily(formats, true);
            formats = newestFormatInFamily.orElse(formats);
        }
        return formats;
    }

    private static Optional<RecordFormats> findLatestFormatInFamily(RecordFormats result, boolean includeDevFormats) {
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(format -> format.getFormatFamily().equals(result.getFormatFamily()) && (includeDevFormats || !format.formatUnderDevelopment())).max(Comparator.comparingInt(RecordFormats::majorVersion).thenComparingInt(RecordFormats::minorVersion));
    }

    public static Iterable<RecordFormats> allFormats() {
        return FormatLoader.AVAILABLE_FORMATS;
    }

    public static RecordFormats findLatestFormatInFamily(String formatFamily, Config config) {
        boolean includeDevFormats = (Boolean)config.get(GraphDatabaseInternalSettings.include_versions_under_development);
        RecordFormats formats = RecordFormatSelector.loadRecordFormat(formatFamily, includeDevFormats);
        if (includeDevFormats && formats != null) {
            Optional<RecordFormats> newestFormatInFamily = RecordFormatSelector.findLatestFormatInFamily(formats, true);
            formats = newestFormatInFamily.orElse(formats);
        }
        return formats;
    }

    public static RecordFormats findLatestMinorVersion(RecordFormats format, Config config) {
        Boolean includeDevFormats = (Boolean)config.get(GraphDatabaseInternalSettings.include_versions_under_development);
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(candidate -> candidate.getFormatFamily().equals(format.getFormatFamily()) && candidate.majorVersion() == format.majorVersion() && candidate.minorVersion() > format.minorVersion() && (includeDevFormats != false || !candidate.formatUnderDevelopment())).max(Comparator.comparingInt(RecordFormats::minorVersion)).orElse(format);
    }

    private static RecordFormats loadRecordFormat(String recordFormat, boolean includeDevFormats) {
        if (StringUtils.isEmpty((CharSequence)recordFormat)) {
            return null;
        }
        if (Standard.LATEST_NAME.equals(recordFormat)) {
            return Standard.LATEST_RECORD_FORMATS;
        }
        for (RecordFormats knownFormat : KNOWN_FORMATS) {
            if (!includeDevFormats && knownFormat.formatUnderDevelopment() || !recordFormat.equals(knownFormat.name())) continue;
            return knownFormat;
        }
        return Iterables.stream(RecordFormatSelector.allFormats()).filter(f -> recordFormat.equals(f.name())).filter(recordFormats -> includeDevFormats || !recordFormats.formatUnderDevelopment()).findFirst().orElse(null);
    }

    private static void info(InternalLogProvider logProvider, String message) {
        logProvider.getLog(RecordFormatSelector.class).info(message);
    }

    private static final class FormatLoader {
        private static final Iterable<RecordFormats> AVAILABLE_FORMATS = FormatLoader.loadFormats();

        private FormatLoader() {
        }

        private static Iterable<RecordFormats> loadFormats() {
            Collection loadableFormatFactories = Services.loadAll(RecordFormats.Factory.class);
            Iterable loadableFormats = Iterables.map(RecordFormats.Factory::getInstance, (Iterable)loadableFormatFactories);
            return Iterables.concat((Iterable[])new Iterable[]{KNOWN_FORMATS, loadableFormats});
        }
    }
}

