/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

public enum Record {
    NULL_REFERENCE(-1, -1),
    NOT_IN_USE(0, 0),
    IN_USE(1, 1),
    RESERVED(-1, -1),
    NO_NEXT_PROPERTY(NULL_REFERENCE),
    NO_PREVIOUS_PROPERTY(NULL_REFERENCE),
    NO_NEXT_RELATIONSHIP(NULL_REFERENCE),
    NO_PREV_RELATIONSHIP(NULL_REFERENCE),
    NO_NEXT_BLOCK(NULL_REFERENCE),
    NODE_PROPERTY(0, 0),
    REL_PROPERTY(2, 2),
    NO_LABELS_FIELD(0, 0);

    public static final int CREATED_IN_TX = 2;
    public static final int REQUIRE_SECONDARY_UNIT = 4;
    public static final int HAS_SECONDARY_UNIT = 8;
    public static final int USES_FIXED_REFERENCE_FORMAT = 16;
    public static final int ADDITIONAL_FLAG_1 = 32;
    public static final int ADDITIONAL_FLAG_2 = 64;
    public static final int ADDITIONAL_FLAG_3 = 128;
    public static final int SECONDARY_UNIT_CREATED_IN_TX = 32;
    public static final int TOKEN_INTERNAL = 32;
    public static final int DYNAMIC_RECORD_START_RECORD = 32;
    public static final int PROPERTY_OWNED_BY_NODE = 64;
    public static final int PROPERTY_OWNED_BY_RELATIONSHIP = 128;
    public static final byte RELATIONSHIP_FIRST_IN_FIRST_CHAIN = 1;
    public static final byte RELATIONSHIP_FIRST_IN_SECOND_CHAIN = 2;
    public static final byte RELATIONSHIP_GROUP_EXTERNAL_DEGREES_OUT = 1;
    public static final byte RELATIONSHIP_GROUP_EXTERNAL_DEGREES_IN = 2;
    public static final byte RELATIONSHIP_GROUP_EXTERNAL_DEGREES_LOOP = 4;
    private final byte byteValue;
    private final int intValue;

    private Record(Record from) {
        this(from.byteValue, from.intValue);
    }

    private Record(byte byteValue, int intValue) {
        this.byteValue = byteValue;
        this.intValue = intValue;
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public long longValue() {
        return this.intValue;
    }

    public boolean is(long value) {
        return value == (long)this.intValue;
    }

    public static boolean isNull(long id) {
        return NULL_REFERENCE.is(id);
    }
}

