/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class DirectRecordStoreMigrator {
    private static final String DIRECT_STORE_MIGRATOR_TAG = "directStoreMigrator";
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final CursorContextFactory contextFactory;
    private final PageCacheTracer pageCacheTracer;

    DirectRecordStoreMigrator(PageCache pageCache, FileSystemAbstraction fs, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
        this.contextFactory = contextFactory;
        this.pageCacheTracer = pageCacheTracer;
    }

    public void migrate(RecordDatabaseLayout fromDirectoryStructure, RecordFormats fromFormat, RecordDatabaseLayout toDirectoryStructure, RecordFormats toFormat, ProgressReporter progressReporter, StoreType[] types, StoreType ... additionalTypesToOpen) throws IOException {
        StoreType[] storesToOpen = (StoreType[])ArrayUtil.concat((Object[])types, (Object[])additionalTypesToOpen);
        progressReporter.start((long)storesToOpen.length);
        try (NeoStores fromStores = new StoreFactory((DatabaseLayout)fromDirectoryStructure, this.config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), this.pageCache, this.pageCacheTracer, this.fs, fromFormat, (InternalLogProvider)NullLogProvider.getInstance(), this.contextFactory, true, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(storesToOpen);
             NeoStores toStores = new StoreFactory((DatabaseLayout)toDirectoryStructure, this.withPersistedStoreHeadersAsConfigFrom(fromStores, storesToOpen), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate(), this.pageCacheTracer, toDirectoryStructure.getDatabaseName()), this.pageCache, this.pageCacheTracer, this.fs, toFormat, (InternalLogProvider)NullLogProvider.getInstance(), this.contextFactory, false, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(storesToOpen);
             CursorContext cursorContext = this.contextFactory.create(DIRECT_STORE_MIGRATOR_TAG);
             CachedStoreCursors toStoreCursors = new CachedStoreCursors(toStores, cursorContext);){
            toStores.start(cursorContext);
            for (StoreType type : types) {
                DirectRecordStoreMigrator.migrate(fromStores.getRecordStore(type), toStores.getRecordStore(type), cursorContext, (StoreCursors)toStoreCursors);
                progressReporter.progress(1L);
            }
        }
    }

    private static <RECORD extends AbstractBaseRecord> void migrate(RecordStore<RECORD> from, RecordStore<RECORD> to, CursorContext cursorContext, StoreCursors toStoreCursors) {
        IdGenerator toIdGenerator = to.getIdGenerator();
        toIdGenerator.setHighestPossibleIdInUse(from.getHighestPossibleIdInUse(cursorContext));
        try (PageCursor toCursor = to.openPageCursorForWriting(0L, cursorContext);
             PageCursor fromCursor = from.openPageCursorForReading(0L, cursorContext);){
            from.scanAllRecords(record -> {
                to.prepareForCommit(record, (IdSequence)toIdGenerator, cursorContext);
                to.updateRecord(record, toCursor, cursorContext, toStoreCursors);
                return false;
            }, fromCursor);
        }
    }

    private Config withPersistedStoreHeadersAsConfigFrom(NeoStores legacyStores, StoreType[] types) {
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.RELATIONSHIP_GROUP))) {
            this.config.set(GraphDatabaseSettings.dense_node_threshold, (Object)legacyStores.getRelationshipGroupStore().getStoreHeaderInt());
        }
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.PROPERTY))) {
            this.config.set(GraphDatabaseInternalSettings.array_block_size, (Object)legacyStores.getPropertyStore().getArrayStore().getRecordDataSize());
            this.config.set(GraphDatabaseInternalSettings.string_block_size, (Object)legacyStores.getPropertyStore().getStringStore().getRecordDataSize());
        }
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.NODE_LABEL))) {
            this.config.set(GraphDatabaseInternalSettings.label_block_size, (Object)legacyStores.getNodeStore().getDynamicLabelStore().getRecordDataSize());
        }
        return this.config;
    }
}

