/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util;

import org.neo4j.cypher.internal.util.CostPerRow;
import org.neo4j.cypher.internal.util.Selectivity;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

public final class PredicateOrdering$
implements Ordering<Tuple2<CostPerRow, Selectivity>> {
    public static final PredicateOrdering$ MODULE$ = new PredicateOrdering$();

    static {
        PartialOrdering.$init$((PartialOrdering)MODULE$);
        Ordering.$init$((Ordering)MODULE$);
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.max$((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.min$((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Tuple2<CostPerRow, Selectivity>> reverse() {
        return Ordering.reverse$((Ordering)this);
    }

    public boolean isReverseOf(Ordering<?> other) {
        return Ordering.isReverseOf$((Ordering)this, other);
    }

    public <U> Ordering<U> on(Function1<U, Tuple2<CostPerRow, Selectivity>> f) {
        return Ordering.on$((Ordering)this, f);
    }

    public Ordering<Tuple2<CostPerRow, Selectivity>> orElse(Ordering<Tuple2<CostPerRow, Selectivity>> other) {
        return Ordering.orElse$((Ordering)this, other);
    }

    public <S> Ordering<Tuple2<CostPerRow, Selectivity>> orElseBy(Function1<Tuple2<CostPerRow, Selectivity>, S> f, Ordering<S> ord) {
        return Ordering.orElseBy$((Ordering)this, f, ord);
    }

    public Ordering.OrderingOps mkOrderingOps(Object lhs) {
        return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
    }

    public int compare(Tuple2<CostPerRow, Selectivity> predicate0, Tuple2<CostPerRow, Selectivity> predicate1) {
        double cost01 = this.costFor(predicate0, predicate1);
        double cost10 = this.costFor(predicate1, predicate0);
        return this.compareWithTolerance(cost01, cost10);
    }

    private int compareWithTolerance(double a, double b) {
        if (package$.MODULE$.abs(a - b) <= 1.0E-6) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    private double costFor(Tuple2<CostPerRow, Selectivity> predicate0, Tuple2<CostPerRow, Selectivity> predicate1) {
        Tuple2 tuple2 = new Tuple2(predicate0, predicate1);
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Tuple2 tuple23 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                CostPerRow costPerRow = (CostPerRow)tuple22._1();
                Selectivity selectivity = (Selectivity)tuple22._2();
                if (costPerRow != null) {
                    double c0 = costPerRow.cost();
                    if (selectivity != null) {
                        CostPerRow costPerRow2;
                        double s0 = selectivity.factor();
                        if (tuple23 != null && (costPerRow2 = (CostPerRow)tuple23._1()) != null) {
                            double c1 = costPerRow2.cost();
                            return c0 + c1 * s0;
                        }
                    }
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PredicateOrdering$.class);
    }

    private PredicateOrdering$() {
    }
}

