/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;

class CypherStringQueryFactory {
    CypherStringQueryFactory() {
    }

    static Query stringPrefix(String prefix) {
        Term term = new Term(ValueEncoding.String.key(0), prefix);
        return new PrefixMultiTermsQuery(term);
    }

    static Query stringContains(String substring) {
        Term term = new Term(ValueEncoding.String.key(0), substring);
        return new ContainsMultiTermsQuery(term);
    }

    static Query stringSuffix(String suffix) {
        Term term = new Term(ValueEncoding.String.key(0), suffix);
        return new SuffixMultiTermsQuery(term);
    }

    private static class PrefixMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        PrefixMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new PrefixTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + this.term + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class PrefixTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef prefix;

            PrefixTermsEnum(TermsEnum termEnum, BytesRef prefix) {
                super(termEnum);
                this.prefix = prefix;
                this.setInitialSeekTerm(this.prefix);
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return StringHelper.startsWith((BytesRef)term, (BytesRef)this.prefix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        }
    }

    private static class ContainsMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        ContainsMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new ContainsTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + this.term + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class ContainsTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef substring;

            ContainsTermsEnum(TermsEnum termsEnum, BytesRef substring) {
                super(termsEnum, false);
                this.substring = substring;
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                if (this.substring.length > term.length) {
                    return FilteredTermsEnum.AcceptStatus.NO;
                }
                byte first = this.substring.bytes[this.substring.offset];
                int max = term.offset + term.length - this.substring.length;
                for (int pos = term.offset; pos <= max; ++pos) {
                    int i;
                    if (term.bytes[pos] != first) {
                        while (++pos <= max && term.bytes[pos] != first) {
                        }
                    }
                    if (pos > max) continue;
                    int end = pos + this.substring.length;
                    int j = this.substring.offset + 1;
                    for (i = pos + 1; i < end && term.bytes[i] == this.substring.bytes[j]; ++i) {
                        ++j;
                    }
                    if (i != end) continue;
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                return FilteredTermsEnum.AcceptStatus.NO;
            }
        }
    }

    private static class SuffixMultiTermsQuery
    extends MultiTermQuery {
        private final Term term;

        SuffixMultiTermsQuery(Term term) {
            super(term.field(), CONSTANT_SCORE_REWRITE);
            this.term = term;
        }

        protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
            return this.term.bytes().length == 0 ? terms.iterator() : new SuffixTermsEnum(terms.iterator(), this.term.bytes());
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + ", term:" + this.term + ", field:" + field;
        }

        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.term.field())) {
                visitor.consumeTerms((Query)this, new Term[]{this.term});
            }
        }

        private static class SuffixTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef suffix;

            SuffixTermsEnum(TermsEnum termsEnum, BytesRef suffix) {
                super(termsEnum, false);
                this.suffix = suffix;
            }

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return StringHelper.endsWith((BytesRef)term, (BytesRef)this.suffix) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.NO;
            }
        }
    }
}

