/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;

class VectorIndexAccessor
extends AbstractLuceneIndexAccessor<VectorIndexReader, DatabaseIndex<VectorIndexReader>> {
    private final VectorSimilarityFunction similarityFunction;

    protected VectorIndexAccessor(DatabaseIndex<VectorIndexReader> luceneIndex, IndexDescriptor descriptor, IndexUpdateIgnoreStrategy ignoreStrategy, VectorSimilarityFunction similarityFunction) {
        super(luceneIndex, descriptor, ignoreStrategy);
        this.similarityFunction = similarityFunction;
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        try {
            return ((VectorIndexReader)this.luceneIndex.getIndexReader(IndexUsageTracker.NO_USAGE_TRACKER)).newAllEntriesValueReader(fromIdInclusive, toIdExclusive);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected IndexUpdater getIndexUpdater(IndexUpdateMode mode) {
        return new VectorIndexUpdater(mode.requiresIdempotency(), mode.requiresRefresh());
    }

    private class VectorIndexUpdater
    extends AbstractLuceneIndexAccessor.AbstractLuceneIndexUpdater {
        VectorIndexUpdater(boolean idempotent, boolean refresh) {
            super(idempotent, refresh);
        }

        @Override
        protected void addIdempotent(long entityId, Value[] values) {
            try {
                Document document = VectorDocumentStructure.createLuceneDocument(entityId, (FloatingPointArray)values[0], VectorIndexAccessor.this.similarityFunction);
                VectorIndexAccessor.this.writer.updateOrDeleteDocument(VectorDocumentStructure.newTermForChangeOrRemove(entityId), document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void add(long entityId, Value[] values) {
            try {
                Document document = VectorDocumentStructure.createLuceneDocument(entityId, (FloatingPointArray)values[0], VectorIndexAccessor.this.similarityFunction);
                VectorIndexAccessor.this.writer.nullableAddDocument(document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void change(long entityId, Value[] values) {
            try {
                Term term = VectorDocumentStructure.newTermForChangeOrRemove(entityId);
                Document document = VectorDocumentStructure.createLuceneDocument(entityId, (FloatingPointArray)values[0], VectorIndexAccessor.this.similarityFunction);
                VectorIndexAccessor.this.writer.updateOrDeleteDocument(term, document);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        protected void remove(long entityId) {
            try {
                Term term = VectorDocumentStructure.newTermForChangeOrRemove(entityId);
                VectorIndexAccessor.this.writer.deleteDocuments(term);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

