/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.document.Document;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunction;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.FloatingPointArray;

class VectorIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<VectorIndexReader>> {
    private final VectorSimilarityFunction similarityFunction;

    VectorIndexPopulator(DatabaseIndex<VectorIndexReader> luceneIndex, IndexUpdateIgnoreStrategy ignoreStrategy, VectorSimilarityFunction similarityFunction) {
        super(luceneIndex, ignoreStrategy);
        this.similarityFunction = similarityFunction;
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        return new VectorIndexPopulatingUpdater(this.writer, this.ignoreStrategy, this.similarityFunction);
    }

    @Override
    protected Document updateAsDocument(ValueIndexEntryUpdate<?> update) {
        long entityId = update.getEntityId();
        FloatingPointArray value = (FloatingPointArray)update.values()[0];
        return VectorDocumentStructure.createLuceneDocument(entityId, value, this.similarityFunction);
    }
}

