/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Operator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StatementCatalog {
    public static Token label(String label) {
        return Token.label(label);
    }

    public static Token type(String type) {
        return Token.type(type);
    }

    public static Property property(String name) {
        return new Property(name);
    }

    public static Property property(Set<Token> owner, String name) {
        return new Property(owner, name);
    }

    public Collection<Token> getAllTokens();

    default public Collection<Token> getNodeLabels() {
        return this.getAllTokens().stream().filter(token -> token.type() == Token.Type.NODE_LABEL).collect(Collectors.toUnmodifiableSet());
    }

    default public Collection<Token> getRelationshipTypes() {
        return this.getAllTokens().stream().filter(token -> token.type() == Token.Type.RELATIONSHIP_TYPE).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<Token> getOutgoingRelations(Token var1);

    public Collection<Token> getTargetNodes(Token var1);

    public Collection<Token> getIncomingRelations(Token var1);

    public Collection<Token> getSourceNodes(Token var1);

    public Collection<Token> getUndirectedRelations(Token var1);

    public Collection<Property> getProperties();

    default public Collection<Filter> getAllFilters() {
        HashSet<Filter> result = new HashSet<Filter>(this.getAllLabelFilters());
        this.getAllPropertyFilters().forEach((p, f) -> result.addAll((Collection<Filter>)f));
        return result;
    }

    public Collection<LabelFilter> getAllLabelFilters();

    public Map<Property, Collection<PropertyFilter>> getAllPropertyFilters();

    default public Collection<PropertyFilter> getFilters(Property property) {
        return this.getAllPropertyFilters().get(property);
    }

    public Collection<Expression> getIdentifiableExpressions();

    public Map<String, Object> getParameters();

    public Collection<String> getParameterNames();

    public Map<String, String> getRenamedParameters();

    public Collection<Literal<?>> getLiterals();

    public record Token(Type type, String value) implements Comparable<Token>
    {
        public static Token label(NodeLabel label) {
            return new Token(Type.NODE_LABEL, Objects.requireNonNull(label, "Label must not be null.").getValue());
        }

        public static Token label(String label) {
            return new Token(Type.NODE_LABEL, Objects.requireNonNull(label, "Label must not be null."));
        }

        public static Token type(String type) {
            return new Token(Type.RELATIONSHIP_TYPE, Objects.requireNonNull(type, "Type must not be null."));
        }

        @Override
        public int compareTo(Token o) {
            int result = this.type().compareTo(o.type());
            if (result == 0) {
                result = this.value().compareTo(o.value());
            }
            return result;
        }

        public static enum Type {
            NODE_LABEL,
            RELATIONSHIP_TYPE;

        }
    }

    public record Property(Set<Token> owningToken, String name) {
        public Property(String name) {
            this(Set.of(), name);
        }

        public Property(Token owningToken, String name) {
            this(Set.of(owningToken), name);
        }

        public Property {
            if (owningToken.stream().map(Token::type).distinct().count() > 1L) {
                throw new IllegalArgumentException("Owning tokens are of multiple types");
            }
            owningToken = Collections.unmodifiableSet(new TreeSet<Token>(owningToken));
        }

        public Optional<Token.Type> owningType() {
            return this.owningToken.stream().map(Token::type).distinct().findFirst();
        }
    }

    public static enum Clause {
        MATCH,
        CREATE,
        MERGE,
        DELETE,
        WITH,
        UNKNOWN;

    }

    public record PropertyFilter(Clause clause, Expression left, Operator operator, Expression right, Set<String> parameterNames, Map<String, Object> parameters) implements Filter
    {
        public PropertyFilter {
            parameterNames = Set.copyOf(parameterNames);
            parameters = Map.copyOf(parameters);
        }
    }

    public record LabelFilter(String symbolicName, Set<Token> value) implements Filter
    {
        public LabelFilter {
            value = Set.copyOf(value);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Filter {
    }
}

