/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.executables;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.executables.DefaultExecutableStatement;
import org.neo4j.cypherdsl.core.executables.ExecutableResultStatement;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.async.AsyncQueryRunner;
import org.neo4j.driver.summary.ResultSummary;

@API(status=API.Status.INTERNAL, since="2021.2.1")
class DefaultExecutableResultStatement
extends DefaultExecutableStatement
implements ExecutableResultStatement {
    DefaultExecutableResultStatement(Statement delegate) {
        super(delegate);
    }

    @Override
    public final <T> List<T> fetchWith(SimpleQueryRunner queryRunner, Function<Record, T> mappingFunction) {
        return queryRunner.run(this.createQuery()).list(mappingFunction);
    }

    @Override
    public final <T> CompletableFuture<List<T>> fetchWith(AsyncQueryRunner queryRunner, Function<Record, T> mappingFunction) {
        return queryRunner.runAsync(this.createQuery()).thenCompose(c -> c.listAsync(mappingFunction)).toCompletableFuture();
    }

    @Override
    public final ResultSummary streamWith(SimpleQueryRunner queryRunner, Consumer<Stream<Record>> consumer) {
        Result result = queryRunner.run(this.createQuery());
        try (Stream stream = result.stream();){
            consumer.accept(stream);
        }
        return result.consume();
    }
}

