/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.versions;

import java.util.Iterator;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphVersion;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.versions.KnownCommunityTopologyComponentVersion;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;

public class CommunityTopologyComponentVersion_1_50
extends KnownCommunityTopologyComponentVersion {
    public CommunityTopologyComponentVersion_1_50() {
        super(CommunityTopologyGraphVersion.COMMUNITY_TOPOLOGY_50);
    }

    @Override
    public void upgradeTopologyGraph(Transaction tx, int fromVersion) throws Exception {
        if (fromVersion < this.version) {
            this.setVersionProperty(tx, this.version);
            this.addDatabaseNameNodes(tx);
            this.addNamespaceProperties(tx);
        }
    }

    private void addNamespaceProperties(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL);){
            Iterators.forEachRemaining((Iterator)nodes, databaseNameNode -> {
                if (!databaseNameNode.hasProperty("namespace")) {
                    databaseNameNode.setProperty("namespace", (Object)"system-root");
                }
                if (!databaseNameNode.hasProperty("displayName")) {
                    databaseNameNode.setProperty("displayName", databaseNameNode.getProperty("name"));
                }
            });
        }
    }
}

