/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.RecordComponent;
import java.time.Clock;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.bolt.tx.TransactionManagerImpl;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DatabaseManagementServiceImpl;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.dbms.database.UnableToStartDatabaseException;
import org.neo4j.dbms.routing.ClientRoutingDomainChecker;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.collector.DataCollector;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.database.DatabaseSizeServiceImpl;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.StatusDetailsAccessor;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.procedure.builtin.SpecialBuiltInProcedures;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureGraphDatabaseAPI;
import org.neo4j.procedure.impl.ProcedureLoginContextTransformer;
import org.neo4j.procedure.impl.TerminationGuardProvider;
import org.neo4j.procedure.impl.TransactionStatusDetailsProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.web.DisabledNeoWebServer;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public class DatabaseManagementServiceFactory {
    protected final DbmsInfo dbmsInfo;
    private final Function<GlobalModule, AbstractEditionModule> editionFactory;

    public DatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory) {
        this.dbmsInfo = dbmsInfo;
        this.editionFactory = editionFactory;
    }

    public DatabaseManagementService build(Config config, boolean daemonMode, ExternalDependencies dependencies) {
        GlobalModule globalModule = this.createGlobalModule(config, daemonMode, dependencies);
        AbstractEditionModule edition = this.editionFactory.apply(globalModule);
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        LifeSupport globalLife = globalModule.getGlobalLife();
        LogService logService = globalModule.getLogService();
        InternalLog internalLog = logService.getInternalLog(this.getClass());
        DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(globalModule.getGlobalConfig());
        SystemGraphComponents.Builder systemGraphComponentsBuilder = CommunityEditionModule.tryResolveOrCreate(SystemGraphComponents.Builder.class, globalModule.getExternalDependencyResolver(), SystemGraphComponents.DefaultBuilder::new);
        systemGraphComponentsBuilder.register((SystemGraphComponent)dbmsRuntimeSystemGraphComponent);
        edition.registerSystemGraphComponents(systemGraphComponentsBuilder, globalModule);
        globalDependencies.satisfyDependency((Object)edition.getSystemGraphComponents());
        DatabaseContextProvider databaseContextProvider = edition.createDatabaseContextProvider(globalModule);
        DatabaseManagementService managementService = this.createManagementService(globalModule, globalLife, internalLog, databaseContextProvider);
        globalDependencies.satisfyDependencies(new Object[]{managementService});
        globalDependencies.satisfyDependency((Object)new DatabaseSizeServiceImpl(databaseContextProvider));
        TopologyInfoService topologyInfoService = edition.createTopologyInfoService(databaseContextProvider);
        globalDependencies.satisfyDependencies(new Object[]{topologyInfoService});
        edition.createDefaultDatabaseResolver(globalModule);
        globalDependencies.satisfyDependency((Object)edition.getDefaultDatabaseResolver());
        ClientRoutingDomainChecker clientRoutingDomainChecker = CommunityEditionModule.tryResolveOrCreate(ClientRoutingDomainChecker.class, (DependencyResolver)globalModule.getGlobalDependencies(), () -> edition.createClientRoutingDomainChecker(globalModule));
        RoutingService routingService = edition.createRoutingService(databaseContextProvider, clientRoutingDomainChecker);
        globalDependencies.satisfyDependency((Object)routingService);
        DatabaseManagementServiceFactory.setupProcedures(globalModule, edition, databaseContextProvider, routingService);
        edition.bootstrapQueryRouterServices(managementService);
        edition.registerDatabaseInitializers(globalModule);
        edition.createSecurityModule(globalModule);
        SecurityProvider securityProvider = edition.getSecurityProvider();
        globalDependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
        DbmsRuntimeRepository dbmsRuntimeRepository = edition.createAndRegisterDbmsRuntimeRepository(globalModule, databaseContextProvider, globalDependencies, dbmsRuntimeSystemGraphComponent);
        globalDependencies.satisfyDependency((Object)dbmsRuntimeRepository);
        globalLife.add((Lifecycle)globalModule.getGlobalExtensions());
        BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI = edition.createBoltDatabaseManagementServiceProvider();
        TransactionManagerImpl transactionManager = new TransactionManagerImpl(boltGraphDatabaseManagementServiceSPI, (Clock)globalModule.getGlobalClock());
        globalDependencies.satisfyDependency((Object)transactionManager);
        BoltServer boltServer = DatabaseManagementServiceFactory.createBoltServer(globalModule, edition, (TransactionManager)transactionManager, routingService);
        globalLife.add((Lifecycle)boltServer);
        globalDependencies.satisfyDependency((Object)boltServer);
        Lifecycle webServer = this.createWebServer(edition, managementService, globalDependencies, (TransactionManager)transactionManager, config, globalModule.getLogService().getUserLogProvider());
        globalDependencies.satisfyDependency((Object)webServer);
        globalLife.add(webServer);
        globalLife.add((Lifecycle)globalModule.getCapabilitiesService());
        DatabaseManagementServiceFactory.startDatabaseServer(globalModule, globalLife, internalLog, databaseContextProvider, managementService);
        DatabaseManagementServiceFactory.dumpDbmsInfo(logService.getUserLog(this.getClass()), ((DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).get()).databaseFacade());
        return managementService;
    }

    protected DatabaseManagementService createManagementService(GlobalModule globalModule, LifeSupport globalLife, InternalLog internalLog, DatabaseContextProvider<?> databaseContextProvider) {
        return new DatabaseManagementServiceImpl(databaseContextProvider, (Lifecycle)globalLife, globalModule.getDatabaseEventListeners(), globalModule.getTransactionEventListeners(), internalLog, globalModule.getGlobalConfig());
    }

    private Lifecycle createWebServer(AbstractEditionModule edition, DatabaseManagementService managementService, Dependencies globalDependencies, TransactionManager transactionManager, Config config, InternalLogProvider userLogProvider) {
        if (DatabaseManagementServiceFactory.shouldEnableWebServer(config)) {
            return edition.createWebServer(managementService, transactionManager, globalDependencies, config, userLogProvider, this.dbmsInfo);
        }
        return new DisabledNeoWebServer();
    }

    private static boolean shouldEnableWebServer(Config config) {
        return ((Boolean)config.get(HttpConnector.enabled) != false || (Boolean)config.get(HttpsConnector.enabled) != false) && !((Set)config.get(ServerSettings.http_enabled_modules)).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startDatabaseServer(GlobalModule globalModule, LifeSupport globalLife, InternalLog internalLog, DatabaseContextProvider<?> databaseContextProvider, DatabaseManagementService managementService) {
        Throwable startupException = null;
        try {
            globalLife.start();
            DatabaseStateService databaseStateService = (DatabaseStateService)globalModule.getGlobalDependencies().resolveDependency(DatabaseStateService.class);
            DatabaseManagementServiceFactory.verifySystemDatabaseStart(databaseContextProvider, databaseStateService);
        }
        catch (Throwable throwable) {
            String message = "Error starting Neo4j database server at " + globalModule.getNeo4jLayout().databasesDirectory();
            startupException = new RuntimeException(message, throwable);
            internalLog.error(message, throwable);
        }
        finally {
            if (startupException != null) {
                try {
                    managementService.shutdown();
                }
                catch (Throwable shutdownError) {
                    startupException.addSuppressed(shutdownError);
                }
            }
        }
        if (startupException != null) {
            internalLog.error("Failed to start database server.", startupException);
            throw startupException;
        }
    }

    private static void verifySystemDatabaseStart(DatabaseContextProvider<?> databaseContextProvider, DatabaseStateService dbStateService) {
        Optional databaseContext = databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        if (databaseContext.isEmpty()) {
            throw new UnableToStartDatabaseException("system not found.");
        }
        Optional failure = dbStateService.causeOfFailure(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        if (failure.isPresent()) {
            throw new UnableToStartDatabaseException("system failed to start.", (Throwable)failure.get());
        }
    }

    protected GlobalModule createGlobalModule(Config config, boolean daemonMode, ExternalDependencies dependencies) {
        return new GlobalModule(config, this.dbmsInfo, daemonMode, dependencies);
    }

    private static void setupProcedures(GlobalModule globalModule, AbstractEditionModule editionModule, DatabaseContextProvider<?> databaseContextProvider, RoutingService routingService) {
        Supplier<GlobalProcedures> procedureInitializer = () -> {
            Config globalConfig = globalModule.getGlobalConfig();
            java.nio.file.Path proceduresDirectory = (java.nio.file.Path)globalConfig.get(GraphDatabaseSettings.plugin_dir);
            LogService logService = globalModule.getLogService();
            InternalLog internalLog = logService.getInternalLog(GlobalProcedures.class);
            InternalLog proceduresLog = logService.getUserLog(GlobalProcedures.class);
            ProcedureConfig procedureConfig = new ProcedureConfig(globalConfig);
            Edition neo4jEdition = globalModule.getDbmsInfo().edition;
            SpecialBuiltInProcedures builtInProcedures = SpecialBuiltInProcedures.from((String)Version.getNeo4jVersion(), (String)neo4jEdition.toString());
            GlobalProceduresRegistry globalProcedures = new GlobalProceduresRegistry((Supplier)builtInProcedures, proceduresDirectory, internalLog, procedureConfig);
            try (GlobalProceduresRegistry.BulkRegistration registry = globalProcedures.bulk();){
                registry.registerType(Node.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
                registry.registerType(NodeValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
                registry.registerType(Relationship.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
                registry.registerType(RelationshipValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
                registry.registerType(Path.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
                registry.registerType(PathValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
                registry.registerType(Geometry.class, (Neo4jTypes.AnyType)Neo4jTypes.NTGeometry);
                registry.registerType(Point.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
                registry.registerType(PointValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
                registry.registerComponent(DependencyResolver.class, Context::dependencyResolver, false);
                registry.registerComponent(KernelTransaction.class, Context::kernelTransaction, false);
                registry.registerComponent(GraphDatabaseAPI.class, Context::graphDatabaseAPI, false);
                registry.registerComponent(SystemGraphComponents.class, ctx -> editionModule.getSystemGraphComponents(), false);
                registry.registerComponent(DataCollector.class, ctx -> (DataCollector)ctx.dependencyResolver().resolveDependency(DataCollector.class), false);
                registry.registerComponent(Log.class, arg_0 -> DatabaseManagementServiceFactory.lambda$setupProcedures$3((Log)proceduresLog, arg_0), true);
                registry.registerComponent(Transaction.class, Context::transaction, true);
                registry.registerComponent(TerminationGuard.class, (ThrowingFunction)new TerminationGuardProvider(), true);
                registry.registerComponent(StatusDetailsAccessor.class, (ThrowingFunction)new TransactionStatusDetailsProvider(), true);
                registry.registerComponent(SecurityContext.class, Context::securityContext, true);
                registry.registerComponent(ProcedureCallContext.class, Context::procedureCallContext, true);
                registry.registerComponent(FulltextAdapter.class, ctx -> (FulltextAdapter)ctx.dependencyResolver().resolveDependency(FulltextAdapter.class), true);
                registry.registerComponent(GraphDatabaseService.class, ctx -> new ProcedureGraphDatabaseAPI(ctx.graphDatabaseAPI(), (Function)new ProcedureLoginContextTransformer(ctx), (Config)ctx.dependencyResolver().resolveDependency(Config.class)), true);
                registry.registerComponent(ValueMapper.class, Context::valueMapper, true);
                try {
                    editionModule.registerProcedures((GlobalProcedures)registry, procedureConfig, globalModule, databaseContextProvider, routingService);
                }
                catch (KernelException e) {
                    internalLog.error("Failed to register built-in edition procedures at start up: " + e.getMessage());
                }
            }
            globalModule.getGlobalLife().add((Lifecycle)globalProcedures);
            return globalProcedures;
        };
        GlobalProcedures procedures = CommunityEditionModule.tryResolveOrCreate(GlobalProcedures.class, globalModule.getExternalDependencyResolver(), procedureInitializer);
        if (procedures instanceof Consumer) {
            ((Consumer)procedures).accept(procedureInitializer);
        }
        globalModule.getGlobalDependencies().satisfyDependency((Object)procedures);
    }

    private static BoltServer createBoltServer(GlobalModule globalModule, AbstractEditionModule edition, TransactionManager transactionManager, RoutingService routingService) {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(globalModule.getLogService().getInternalLogProvider()));
        return new BoltServer(globalModule.getDbmsInfo(), globalModule.getJobScheduler(), globalModule.getConnectorPortRegister(), edition.getConnectionTracker(), transactionManager, globalModule.getGlobalConfig(), globalModule.getGlobalClock(), globalModule.getGlobalMonitors(), globalModule.getLogService(), (DependencyResolver)globalModule.getGlobalDependencies(), edition.getBoltAuthManager((DependencyResolver)globalModule.getGlobalDependencies()), edition.getBoltInClusterAuthManager(), edition.getBoltLoopbackAuthManager(), globalModule.getMemoryPools(), routingService, edition.getDefaultDatabaseResolver());
    }

    private static void dumpDbmsInfo(InternalLog log, GraphDatabaseAPI system) {
        try {
            for (BuiltInDbmsProcedures.SystemInfo info : BuiltInDbmsProcedures.dbmsInfo((GraphDatabaseAPI)system).toList()) {
                for (RecordComponent recordComponent : BuiltInDbmsProcedures.SystemInfo.class.getRecordComponents()) {
                    log.info(recordComponent.getName() + ": " + recordComponent.getAccessor().invoke((Object)info, new Object[0]));
                }
            }
        }
        catch (Exception e) {
            log.info("Unable to dump DBMS information", (Throwable)e);
        }
    }

    private static /* synthetic */ Log lambda$setupProcedures$3(Log proceduresLog, Context ctx) throws ProcedureException {
        return proceduresLog;
    }
}

