/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.configuration.database.readonly.ConfigReadOnlyDatabaseListener;
import org.neo4j.dbms.CommunityDatabaseStateService;
import org.neo4j.dbms.CommunityKernelPanicListener;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DatabaseContextProviderDelegate;
import org.neo4j.dbms.database.DatabaseLifecycles;
import org.neo4j.dbms.database.DatabaseOperationCounts;
import org.neo4j.dbms.database.DatabaseReferenceCacheClearingListener;
import org.neo4j.dbms.database.DatabaseRepository;
import org.neo4j.dbms.database.DatabaseStateMonitor;
import org.neo4j.dbms.database.DefaultDatabaseContextFactory;
import org.neo4j.dbms.database.DefaultDatabaseContextFactoryComponents;
import org.neo4j.dbms.database.DefaultDatabaseDetailsExtrasProvider;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.DefaultSystemGraphInitializer;
import org.neo4j.dbms.database.DefaultTopologyInfoService;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyDatabaseLookupFactory;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyListener;
import org.neo4j.dbms.identity.DefaultIdentityModule;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.identity.ServerIdentityFactory;
import org.neo4j.dbms.routing.ClientRoutingDomainChecker;
import org.neo4j.dbms.routing.ClientSideRoutingTableProvider;
import org.neo4j.dbms.routing.DatabaseAvailabilityChecker;
import org.neo4j.dbms.routing.DefaultDatabaseAvailabilityChecker;
import org.neo4j.dbms.routing.DefaultRoutingService;
import org.neo4j.dbms.routing.LocalRoutingTableServiceValidator;
import org.neo4j.dbms.routing.RoutingOption;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.RoutingTableServiceValidator;
import org.neo4j.dbms.routing.RoutingTableTTLProvider;
import org.neo4j.dbms.routing.ServerSideRoutingTableProvider;
import org.neo4j.dbms.routing.SingleAddressRoutingTableProvider;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphComponent;
import org.neo4j.fabric.bootstrap.FabricServicesBootstrap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.provider.NoAuthSecurityProvider;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseReferenceRepository;
import org.neo4j.kernel.database.SystemGraphDatabaseIdRepository;
import org.neo4j.kernel.database.SystemGraphDatabaseReferenceRepository;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.CommunityIOControllerService;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.router.CommunityQueryRouterBoostrap;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.rest.repr.CommunityAuthConfigProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.systemgraph.CommunityDefaultDatabaseResolver;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.SystemNanoClock;

public class CommunityEditionModule
extends AbstractEditionModule
implements DefaultDatabaseContextFactoryComponents {
    protected final SslPolicyLoader sslPolicyLoader;
    protected final GlobalModule globalModule;
    protected final ServerIdentity identityModule;
    private final MapCachingDatabaseReferenceRepository databaseReferenceRepo;
    private final DeviceMapper deviceMapper;
    protected DatabaseStateService databaseStateService;
    protected ReadOnlyDatabases globalReadOnlyChecker;
    private Lifecycle defaultDatabaseInitializer = new LifecycleAdapter();
    private SystemGraphComponents systemGraphComponents;

    public CommunityEditionModule(GlobalModule globalModule) {
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        Config globalConfig = globalModule.getGlobalConfig();
        LogService logService = globalModule.getLogService();
        this.globalModule = globalModule;
        this.sslPolicyLoader = SslPolicyLoader.create((FileSystemAbstraction)globalModule.getFileSystem(), (Config)globalConfig, (InternalLogProvider)logService.getInternalLogProvider());
        globalDependencies.satisfyDependency((Object)this.sslPolicyLoader);
        globalDependencies.satisfyDependency((Object)new DatabaseOperationCounts.Counter());
        globalDependencies.satisfyDependency((Object)new DatabaseStateMonitor.Counter());
        globalDependencies.satisfyDependency((Object)this.createAuthConfigProvider(globalModule));
        this.identityModule = CommunityEditionModule.tryResolveOrCreate(ServerIdentityFactory.class, globalModule.getExternalDependencyResolver(), DefaultIdentityModule::fromGlobalModule).create(globalModule);
        globalDependencies.satisfyDependency((Object)this.identityModule);
        this.deviceMapper = DeviceMapper.UNKNOWN_MAPPER;
        globalDependencies.satisfyDependency((Object)this.deviceMapper);
        this.connectionTracker = (NetworkConnectionTracker)globalDependencies.satisfyDependency((Object)CommunityEditionModule.createConnectionTracker());
        this.databaseReferenceRepo = (MapCachingDatabaseReferenceRepository)globalDependencies.satisfyDependency((Object)new MapCachingDatabaseReferenceRepository());
    }

    public DatabaseContextProvider<?> createDatabaseContextProvider(GlobalModule globalModule) {
        DefaultDatabaseContextFactory databaseContextFactory = new DefaultDatabaseContextFactory(globalModule, this.identityModule, this.getTransactionMonitorFactory(), this.getIndexMonitorFactory(), CommunityEditionModule.createIdContextFactory(globalModule), this.deviceMapper, (IOControllerService)new CommunityIOControllerService(), this.createCommitProcessFactory(), this);
        MapCachingDatabaseIdRepository databaseIdRepo = new MapCachingDatabaseIdRepository();
        DatabaseRepository databaseRepository = new DatabaseRepository((DatabaseIdRepository)databaseIdRepo);
        DatabaseIdRepository rootDatabaseIdRepository = CommunityEditionModule.tryResolveOrCreate(DatabaseIdRepository.class, globalModule.getExternalDependencyResolver(), () -> new SystemGraphDatabaseIdRepository(() -> databaseRepository.getDatabaseContext(DatabaseId.SYSTEM_DATABASE_ID), globalModule.getLogService().getInternalLogProvider()));
        DatabaseReferenceRepository rootDatabaseReferenceRepository = CommunityEditionModule.tryResolveOrCreate(DatabaseReferenceRepository.class, globalModule.getExternalDependencyResolver(), () -> new SystemGraphDatabaseReferenceRepository(() -> ((DatabaseRepository)databaseRepository).getSystemDatabaseContext()));
        databaseIdRepo.setDelegate(rootDatabaseIdRepository);
        this.databaseReferenceRepo.setDelegate(rootDatabaseReferenceRepository);
        DatabaseReferenceCacheClearingListener databaseIdCacheCleaner = new DatabaseReferenceCacheClearingListener((DatabaseIdRepository.Caching)databaseIdRepo, (DatabaseReferenceRepository.Caching)this.databaseReferenceRepo);
        CommunityKernelPanicListener kernelPanicListener = new CommunityKernelPanicListener(globalModule.getDatabaseEventListeners(), (DatabaseContextProvider<StandaloneDatabaseContext>)databaseRepository);
        globalModule.getGlobalLife().add((Lifecycle)kernelPanicListener);
        DatabaseLifecycles databaseLifecycles = new DatabaseLifecycles((DatabaseRepository<StandaloneDatabaseContext>)databaseRepository, (String)globalModule.getGlobalConfig().get(GraphDatabaseSettings.initial_default_database), databaseContextFactory, (LogProvider)globalModule.getLogService().getInternalLogProvider());
        this.databaseStateService = new CommunityDatabaseStateService((DatabaseContextProvider<StandaloneDatabaseContext>)databaseRepository);
        globalModule.getGlobalLife().add(databaseLifecycles.systemDatabaseStarter());
        globalModule.getGlobalLife().add(databaseLifecycles.allDatabaseShutdown());
        globalModule.getGlobalDependencies().satisfyDependency((Object)DatabaseContextProviderDelegate.delegate((DatabaseContextProvider)databaseRepository));
        globalModule.getGlobalDependencies().satisfyDependency((Object)this.databaseStateService);
        this.globalReadOnlyChecker = CommunityEditionModule.createGlobalReadOnlyChecker(databaseRepository, globalModule.getGlobalConfig(), globalModule.getTransactionEventListeners(), globalModule.getGlobalLife(), globalModule.getLogService().getInternalLogProvider());
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)databaseIdCacheCleaner);
        this.defaultDatabaseInitializer = databaseLifecycles.defaultDatabaseStarter();
        globalModule.getGlobalDependencies().satisfyDependency((Object)new BuiltInDbmsProcedures.UpgradeAllowedChecker.UpgradeAlwaysAllowed());
        return databaseRepository;
    }

    private static ReadOnlyDatabases createGlobalReadOnlyChecker(DatabaseContextProvider<?> databaseContextProvider, Config globalConfig, GlobalTransactionEventListeners txListeners, LifeSupport globalLife, InternalLogProvider logProvider) {
        SystemGraphReadOnlyDatabaseLookupFactory systemGraphReadOnlyLookup = new SystemGraphReadOnlyDatabaseLookupFactory(databaseContextProvider, logProvider);
        ConfigBasedLookupFactory configReadOnlyLookup = new ConfigBasedLookupFactory(globalConfig, databaseContextProvider.databaseIdRepository());
        DefaultReadOnlyDatabases globalChecker = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{systemGraphReadOnlyLookup, configReadOnlyLookup});
        ConfigReadOnlyDatabaseListener configListener = new ConfigReadOnlyDatabaseListener((ReadOnlyDatabases)globalChecker, globalConfig);
        SystemGraphReadOnlyListener systemGraphListener = new SystemGraphReadOnlyListener(txListeners, (ReadOnlyDatabases)globalChecker);
        globalLife.add((Lifecycle)configListener);
        globalLife.add((Lifecycle)systemGraphListener);
        return globalChecker;
    }

    @Override
    public Lifecycle createWebServer(DatabaseManagementService managementService, TransactionManager transactionManager, Dependencies globalDependencies, Config config, InternalLogProvider userLogProvider, DbmsInfo dbmsInfo) {
        return new CommunityNeoWebServer(managementService, transactionManager, globalDependencies, config, userLogProvider, dbmsInfo, this.globalModule.getMemoryPools(), this.globalModule.getGlobalClock());
    }

    @Override
    public TopologyInfoService createTopologyInfoService(DatabaseContextProvider<?> databaseContextProvider) {
        DefaultDatabaseDetailsExtrasProvider detailsExtrasProvider = new DefaultDatabaseDetailsExtrasProvider(databaseContextProvider);
        return new DefaultTopologyInfoService(this.identityModule.serverId(), this.globalModule.getGlobalConfig(), this.databaseStateService, this.globalReadOnlyChecker, detailsExtrasProvider);
    }

    @Override
    public RoutingService createRoutingService(DatabaseContextProvider<?> databaseContextProvider, ClientRoutingDomainChecker clientRoutingDomainChecker) {
        LogService logService = this.globalModule.getLogService();
        ConnectorPortRegister portRegister = this.globalModule.getConnectorPortRegister();
        Config config = this.globalModule.getGlobalConfig();
        InternalLogProvider logProvider = this.globalModule.getLogService().getInternalLogProvider();
        DefaultDatabaseAvailabilityChecker databaseAvailabilityChecker = new DefaultDatabaseAvailabilityChecker(databaseContextProvider);
        LocalRoutingTableServiceValidator validator = new LocalRoutingTableServiceValidator((DatabaseAvailabilityChecker)databaseAvailabilityChecker);
        SingleAddressRoutingTableProvider routingTableProvider = new SingleAddressRoutingTableProvider(portRegister, RoutingOption.ROUTE_WRITE_AND_READ, config, logProvider, RoutingTableTTLProvider.ttlFromConfig((Config)config));
        return new DefaultRoutingService(logService.getInternalLogProvider(), (RoutingTableServiceValidator)validator, (ClientSideRoutingTableProvider)routingTableProvider, (ServerSideRoutingTableProvider)routingTableProvider, clientRoutingDomainChecker, config, () -> true, this.defaultDatabaseResolver, (DatabaseReferenceRepository)this.databaseReferenceRepo);
    }

    @Override
    protected AuthConfigProvider createAuthConfigProvider(GlobalModule globalModule) {
        return new CommunityAuthConfigProvider();
    }

    @Override
    public void registerDatabaseInitializers(GlobalModule globalModule) {
        this.registerSystemGraphInitializer(globalModule);
        this.registerDefaultDatabaseInitializer(globalModule);
    }

    private void registerSystemGraphInitializer(GlobalModule globalModule) {
        Supplier<GraphDatabaseService> systemSupplier = CommunityEditionModule.systemSupplier((DependencyResolver)globalModule.getGlobalDependencies());
        SystemGraphInitializer initializer = CommunityEditionModule.tryResolveOrCreate(SystemGraphInitializer.class, globalModule.getExternalDependencyResolver(), () -> new DefaultSystemGraphInitializer(systemSupplier, this.systemGraphComponents));
        globalModule.getGlobalDependencies().satisfyDependency((Object)initializer);
        globalModule.getGlobalLife().add((Lifecycle)initializer);
    }

    protected void registerDefaultDatabaseInitializer(GlobalModule globalModule) {
        globalModule.getGlobalLife().add(this.defaultDatabaseInitializer);
    }

    @Override
    public void registerSystemGraphComponents(SystemGraphComponents.Builder systemGraphComponentsBuilder, GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        InternalLogProvider log = globalModule.getLogService().getInternalLogProvider();
        SystemNanoClock clock = globalModule.getGlobalClock();
        DefaultSystemGraphComponent systemGraphComponent = new DefaultSystemGraphComponent(config, (Clock)clock);
        CommunityTopologyGraphComponent communityTopologyGraphComponentComponent = new CommunityTopologyGraphComponent(config, log);
        systemGraphComponentsBuilder.register((SystemGraphComponent)systemGraphComponent);
        systemGraphComponentsBuilder.register((SystemGraphComponent)communityTopologyGraphComponentComponent);
        this.registerSecurityGraphComponent(systemGraphComponentsBuilder, globalModule);
        this.systemGraphComponents = systemGraphComponentsBuilder.build();
    }

    private void registerSecurityGraphComponent(SystemGraphComponents.Builder systemGraphComponentsBuilder, GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        FileSystemAbstraction fileSystem = globalModule.getFileSystem();
        InternalLogProvider logProvider = globalModule.getLogService().getInternalLogProvider();
        CommunitySecurityLog securityLog = new CommunitySecurityLog(logProvider.getLog(CommunitySecurityModule.class));
        UserSecurityGraphComponent communityComponent = CommunitySecurityModule.createSecurityComponent((Config)config, (FileSystemAbstraction)fileSystem, (InternalLogProvider)logProvider, (AbstractSecurityLog)securityLog, (MemoryTracker)globalModule.getOtherMemoryPool().getPoolMemoryTracker());
        systemGraphComponentsBuilder.register((SystemGraphComponent)communityComponent);
    }

    @Override
    public void createSecurityModule(GlobalModule globalModule) {
        this.setSecurityProvider(this.makeSecurityModule(globalModule));
    }

    @Override
    public DatabaseReferenceRepository getDatabaseReferenceRepo() {
        return this.databaseReferenceRepo;
    }

    private SecurityProvider makeSecurityModule(GlobalModule globalModule) {
        globalModule.getGlobalDependencies().satisfyDependency((Object)CommunitySecurityLog.NULL_LOG);
        if (((Boolean)globalModule.getGlobalConfig().get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            CommunitySecurityModule securityModule = new CommunitySecurityModule(globalModule.getLogService(), globalModule.getGlobalConfig(), globalModule.getGlobalDependencies());
            securityModule.setup();
            return securityModule;
        }
        return NoAuthSecurityProvider.INSTANCE;
    }

    @Override
    public void createDefaultDatabaseResolver(GlobalModule globalModule) {
        Supplier<GraphDatabaseService> systemDbSupplier = CommunityEditionModule.systemSupplier((DependencyResolver)globalModule.getGlobalDependencies());
        CommunityDefaultDatabaseResolver defaultDatabaseResolver = new CommunityDefaultDatabaseResolver(globalModule.getGlobalConfig(), systemDbSupplier);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)defaultDatabaseResolver);
        this.defaultDatabaseResolver = defaultDatabaseResolver;
    }

    @Override
    public BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider() {
        return (BoltGraphDatabaseManagementServiceSPI)this.globalModule.getGlobalDependencies().resolveDependency(BoltGraphDatabaseManagementServiceSPI.class);
    }

    protected CommitProcessFactory createCommitProcessFactory() {
        return new CommunityCommitProcessFactory();
    }

    @Override
    public void bootstrapQueryRouterServices(DatabaseManagementService databaseManagementService) {
        DatabaseContextProvider databaseRepository = (DatabaseContextProvider)this.globalModule.getGlobalDependencies().resolveDependency(DatabaseContextProvider.class);
        if (((Boolean)this.globalModule.getGlobalConfig().get(GraphDatabaseInternalSettings.query_router_new_stack)).booleanValue()) {
            CommunityQueryRouterBoostrap queryRouterBoostrap = new CommunityQueryRouterBoostrap(this.globalModule.getGlobalLife(), this.globalModule.getGlobalDependencies(), this.globalModule.getLogService(), databaseRepository, (DatabaseReferenceRepository)this.databaseReferenceRepo);
            this.globalModule.getGlobalDependencies().satisfyDependency((Object)queryRouterBoostrap.bootstrapServices(databaseManagementService));
        } else {
            FabricServicesBootstrap.Community fabricServicesBootstrap = new FabricServicesBootstrap.Community(this.globalModule.getGlobalLife(), this.globalModule.getGlobalDependencies(), this.globalModule.getLogService(), databaseRepository, (DatabaseReferenceRepository)this.databaseReferenceRepo);
            this.globalModule.getGlobalDependencies().satisfyDependency((Object)fabricServicesBootstrap.bootstrapServices(databaseManagementService));
        }
    }

    @Override
    public ReadOnlyDatabases readOnlyDatabases() {
        return this.globalReadOnlyChecker;
    }

    @Override
    public SystemGraphComponents getSystemGraphComponents() {
        return this.systemGraphComponents;
    }
}

