/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Environment;
import org.neo4j.server.startup.Neo4jAdminCommand;
import org.neo4j.server.startup.Neo4jCommand;
import picocli.AutoComplete;
import picocli.CommandLine;

@CommandLine.Command(name="generate-tab-completion", description={"Generates tab completion scripts for neo4j & neo4j-admin CLI on Bash and ZSH"})
public class TabCompletionGenerator
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Output directory"})
    private Path output;

    private void dumpTabCompletionForCommand(Neo4jAdminCommand command) throws IOException {
        CommandLine commandLine = command.getActualAdminCommand(new ExecutionContext(this.output, this.output));
        String name = commandLine.getCommand().getClass().getAnnotation(CommandLine.Command.class).name();
        String script = AutoComplete.bash((String)name, (CommandLine)commandLine);
        Path file = this.output.resolve(name + "_completion");
        Files.writeString(file, (CharSequence)script, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public Integer call() throws Exception {
        if (Files.exists(this.output, new LinkOption[0]) && !Files.isDirectory(this.output, new LinkOption[0])) {
            throw new FileAlreadyExistsException(this.output.toString() + " Needs to be a directory");
        }
        Files.createDirectories(this.output, new FileAttribute[0]);
        this.dumpTabCompletionForCommand(new Neo4jAdminCommand(Environment.SYSTEM));
        this.dumpTabCompletionForCommand(new Neo4jCommand(Environment.SYSTEM));
        return 0;
    }

    public static void main(String[] args) {
        new CommandLine((Object)new TabCompletionGenerator()).execute(args);
    }
}

