/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;

public class NFAStateBuilder {
    private int id = 0;
    private final ArrayList<BuilderState> builderStates = new ArrayList();
    private HashMap<Integer, State> idToState;

    public BuilderState newState(State.VarName varName, boolean isStartState, boolean isFinalState) {
        BuilderState builderState = new BuilderState(this.id++, varName, isStartState, isFinalState);
        this.builderStates.add(builderState);
        return builderState;
    }

    public BuilderState newState() {
        return this.newState(new State.VarName("STATE-" + this.id, true), false, false);
    }

    public BuilderState newStartState() {
        return this.newState(new State.VarName("START-STATE-" + this.id, true), true, false);
    }

    public BuilderState newFinalState() {
        return this.newState(new State.VarName("FINAL-STATE-" + this.id, true), false, true);
    }

    public BuilderState newStartAndFinalState() {
        return this.newState(new State.VarName("START-AND-FINAL-STATE-" + this.id, true), true, true);
    }

    public State build() {
        State startState = null;
        HashMap<NodeJuxtaposition, Integer> nodeLinks = new HashMap<NodeJuxtaposition, Integer>();
        HashMap<RelationshipExpansion, Integer> relLinks = new HashMap<RelationshipExpansion, Integer>();
        this.idToState = new HashMap();
        for (BuilderState builderState : this.builderStates) {
            State state = builderState.build(nodeLinks, relLinks);
            if (builderState.isStartState) {
                startState = state;
            }
            this.idToState.put(builderState.id, state);
        }
        for (Map.Entry entry : nodeLinks.entrySet()) {
            ((NodeJuxtaposition)entry.getKey()).setTargetState(this.idToState.get(entry.getValue()));
        }
        for (Map.Entry entry : relLinks.entrySet()) {
            ((RelationshipExpansion)entry.getKey()).setTargetState(this.idToState.get(entry.getValue()));
        }
        assert (startState != null) : "There should be exactly one start state";
        return startState;
    }

    public class BuilderState {
        protected final int id;
        protected final State.VarName varName;
        private final ArrayList<BuilderNodeJuxtaposition> builderNodeJuxtapositions;
        private final ArrayList<BuilderRelationshipExpansion> builderRelationshipExpansions;
        private final boolean isStartState;
        private final boolean isFinalState;

        private BuilderState(int id, State.VarName varName, boolean isStartState, boolean isFinalState) {
            this.id = id;
            this.varName = varName;
            this.isStartState = isStartState;
            this.isFinalState = isFinalState;
            this.builderNodeJuxtapositions = new ArrayList();
            this.builderRelationshipExpansions = new ArrayList();
        }

        public void addNodeJuxtaposition(BuilderNodeJuxtaposition builderNodeJuxtaposition) {
            this.builderNodeJuxtapositions.add(builderNodeJuxtaposition);
        }

        public void addNodeJuxtaposition(LongPredicate nodePredicates, BuilderState targetBuilderState) {
            this.addNodeJuxtaposition(new BuilderNodeJuxtaposition(nodePredicates, targetBuilderState));
        }

        public void addRelationshipExpansion(BuilderRelationshipExpansion builderRelationshipExpansion) {
            this.builderRelationshipExpansions.add(builderRelationshipExpansion);
        }

        public void addRelationshipExpansion(Predicate<RelationshipTraversalCursor> relPredicate, int[] types, Direction direction, State.VarName relName, LongPredicate nodePredicate, BuilderState targetBuilderState) {
            this.addRelationshipExpansion(new BuilderRelationshipExpansion(relPredicate, types, direction, relName, nodePredicate, targetBuilderState));
        }

        public State build(Map<NodeJuxtaposition, Integer> nodeLinks, Map<RelationshipExpansion, Integer> relLinks) {
            return new State(this.id, this.varName, (NodeJuxtaposition[])this.builderNodeJuxtapositions.stream().map(t -> t.build(nodeLinks)).toArray(NodeJuxtaposition[]::new), (RelationshipExpansion[])this.builderRelationshipExpansions.stream().map(t -> t.build(relLinks)).toArray(RelationshipExpansion[]::new), this.isStartState, this.isFinalState);
        }

        public State state() {
            assert (NFAStateBuilder.this.idToState != null) : "A BuilderState can't be converted to a State before the ProductGraphTraversalCursorBuilder which built the state has had .build() called on it";
            return NFAStateBuilder.this.idToState.get(this.id);
        }

        public int id() {
            return this.id;
        }

        public State.VarName varName() {
            return this.varName;
        }
    }

    public record BuilderRelationshipExpansion(Predicate<RelationshipTraversalCursor> relPredicate, int[] types, Direction direction, State.VarName relName, LongPredicate nodePredicate, BuilderState targetBuilderState) {
        private RelationshipExpansion build(Map<RelationshipExpansion, Integer> links) {
            RelationshipExpansion relationshipExpansion = new RelationshipExpansion(this.relPredicate, this.types, this.direction, this.relName, this.nodePredicate, null);
            links.put(relationshipExpansion, this.targetBuilderState.id());
            return relationshipExpansion;
        }
    }

    public record BuilderNodeJuxtaposition(LongPredicate nodePredicates, BuilderState targetBuilderState) {
        private NodeJuxtaposition build(Map<NodeJuxtaposition, Integer> links) {
            NodeJuxtaposition nodeJuxtaposition = new NodeJuxtaposition(this.nodePredicates, null);
            links.put(nodeJuxtaposition, this.targetBuilderState.id());
            return nodeJuxtaposition;
        }
    }
}

