/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static int[] union(int[] lhs, int[] rhs) {
        if (lhs == null || rhs == null) {
            return lhs == null ? rhs : lhs;
        }
        assert (PrimitiveArrays.isSortedSet(lhs) && PrimitiveArrays.isSortedSet(rhs));
        if (lhs.length < rhs.length) {
            return PrimitiveArrays.union(rhs, lhs);
        }
        int[] merged = null;
        int m = 0;
        int l = 0;
        int r = 0;
        while (l <= lhs.length && r < rhs.length) {
            while (l < lhs.length && lhs[l] < rhs[r]) {
                if (merged != null) {
                    merged[m++] = lhs[l];
                }
                ++l;
            }
            if (l == lhs.length) {
                if (merged == null) {
                    merged = Arrays.copyOf(lhs, lhs.length + rhs.length - r);
                    m = l;
                }
                System.arraycopy(rhs, r, merged, m, rhs.length - r);
                m += rhs.length - r;
                break;
            }
            if (lhs[l] > rhs[r]) {
                if (merged == null) {
                    merged = Arrays.copyOf(lhs, lhs.length + rhs.length - r);
                    m = l;
                }
                merged[m++] = rhs[r++];
                continue;
            }
            if (merged != null) {
                merged[m++] = lhs[l];
            }
            ++l;
            ++r;
        }
        if (merged == null) {
            return lhs;
        }
        if (l < lhs.length) {
            System.arraycopy(lhs, l, merged, m, lhs.length - l);
            m += lhs.length - l;
        }
        if (m < merged.length) {
            merged = Arrays.copyOf(merged, m);
        }
        return merged;
    }

    public static long[] intersect(long[] left, long[] right) {
        if (left == null || right == null) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        assert (PrimitiveArrays.isSortedSet(left) && PrimitiveArrays.isSortedSet(right));
        long uniqueCounts = PrimitiveArrays.countUnique(left, right);
        if (uniqueCounts == 0L) {
            return right;
        }
        if (PrimitiveArrays.right(uniqueCounts) == right.length || PrimitiveArrays.left(uniqueCounts) == left.length) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] intersect = new long[left.length - PrimitiveArrays.left(uniqueCounts)];
        int cursor = 0;
        int l = 0;
        int r = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                intersect[cursor++] = left[l];
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                ++l;
                continue;
            }
            ++r;
        }
        assert (cursor == intersect.length);
        return intersect;
    }

    public static long[] symmetricDifference(long[] left, long[] right) {
        if (left == null || right == null) {
            return left == null ? right : left;
        }
        assert (PrimitiveArrays.isSortedSet(left) && PrimitiveArrays.isSortedSet(right));
        long uniqueCounts = PrimitiveArrays.countUnique(left, right);
        if (uniqueCounts == 0L) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] difference = new long[PrimitiveArrays.left(uniqueCounts) + PrimitiveArrays.right(uniqueCounts)];
        int cursor = 0;
        int l = 0;
        int r = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                difference[cursor++] = left[l];
                ++l;
                continue;
            }
            difference[cursor++] = right[r];
            ++r;
        }
        while (l < left.length) {
            difference[cursor++] = left[l];
            ++l;
        }
        while (r < right.length) {
            difference[cursor++] = right[r];
            ++r;
        }
        assert (cursor == difference.length);
        return difference;
    }

    static long countUnique(long[] left, long[] right) {
        int l = 0;
        int r = 0;
        int uniqueInLeft = 0;
        int uniqueInRight = 0;
        while (l < left.length && r < right.length) {
            if (left[l] == right[r]) {
                ++l;
                ++r;
                continue;
            }
            if (left[l] < right[r]) {
                ++uniqueInLeft;
                ++l;
                continue;
            }
            ++uniqueInRight;
            ++r;
        }
        return PrimitiveArrays.intPair(uniqueInLeft += left.length - l, uniqueInRight += right.length - r);
    }

    public static boolean sortedContains(int[] array, int key) {
        return Arrays.binarySearch(array, key) >= 0;
    }

    public static boolean contains(int[] list, int value) {
        for (int x : list) {
            if (value != x) continue;
            return true;
        }
        return false;
    }

    private static long intPair(int left, int right) {
        return (long)left << 32 | (long)right;
    }

    private static int left(long pair) {
        return (int)(pair >> 32);
    }

    private static int right(long pair) {
        return (int)(pair & 0xFFFFFFFFL);
    }

    private static boolean isSortedSet(int[] set) {
        for (int i = 0; i < set.length - 1; ++i) {
            assert (set[i] < set[i + 1]) : "Array is not a sorted set: has " + set[i] + " before " + set[i + 1];
        }
        return true;
    }

    private static boolean isSortedSet(long[] set) {
        for (int i = 0; i < set.length - 1; ++i) {
            assert (set[i] < set[i + 1]) : "Array is not a sorted set: has " + set[i] + " before " + set[i + 1];
        }
        return true;
    }

    public static long[] intsToLongs(int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }
}

