/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.literal.interpreter.LiteralInterpreter;
import org.neo4j.cypher.internal.parser.javacc.CharStream;
import org.neo4j.cypher.internal.parser.javacc.Cypher;
import org.neo4j.cypher.internal.parser.javacc.CypherCharStream;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ParameterException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterPrettyRenderer;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ShellParameterService
implements ParameterService {
    private static final Logger log = Logger.create();
    private final Map<String, Value> parameters = new HashMap<String, Value>();
    private final ParameterService.ParameterParser parser = new ShellParameterParser();
    private final ParameterService.ParameterEvaluator evaluator;
    private final ParameterPrettyRenderer prettyRenderer = ParameterPrettyRenderer.create();

    ShellParameterService(TransactionHandler db) {
        this.evaluator = new ShellParameterEvaluator(db);
    }

    @Override
    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<ParameterService.Parameter> parameters) {
        parameters.forEach(p -> this.parameters.put(p.name(), p.value()));
    }

    @Override
    public List<ParameterService.Parameter> evaluate(ParameterService.RawParameters parameter) throws CommandException {
        return this.evaluator.evaluate(parameter);
    }

    @Override
    public ParameterService.RawParameters parse(String input) throws ParameterService.ParameterParsingException {
        return this.parser.parse(input);
    }

    @Override
    public String pretty() {
        return this.prettyRenderer.pretty(this.parameters());
    }

    @Override
    public void clear() {
        this.parameters.clear();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ShellParameterParser
    implements ParameterService.ParameterParser {
        private final CypherMapParameterParser mapParser = new CypherMapParameterParser();
        private final ArrowParameterParser arrowParser = new ArrowParameterParser();

        @Override
        public ParameterService.RawParameters parse(String input) throws ParameterService.ParameterParsingException {
            return this.doParse(ShellParameterParser.stripTrailingSemicolon(input));
        }

        private ParameterService.RawParameters doParse(String input) throws ParameterService.ParameterParsingException {
            return Optional.ofNullable(this.mapParser.parse(input)).or(() -> Optional.ofNullable(this.arrowParser.parse(input))).orElseThrow(ParameterService.ParameterParsingException::new);
        }

        private static String stripTrailingSemicolon(String input) {
            return StringUtils.stripEnd((String)input.trim(), (String)";");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class ShellParameterEvaluator
    implements ParameterService.ParameterEvaluator {
        private final LiteralInterpreter interpreter = new LiteralInterpreter();
        private final TransactionHandler db;

        private ShellParameterEvaluator(TransactionHandler db) {
            this.db = db;
        }

        @Override
        public List<ParameterService.Parameter> evaluate(ParameterService.RawParameters parameter) throws CommandException {
            String exp = parameter.expression();
            Value parameterMap = this.evaluateOffline(exp).orElseGet(() -> this.evaluateOnline(exp));
            return this.asParameters(exp, parameterMap);
        }

        private List<ParameterService.Parameter> asParameters(String expression, Value value) {
            if (value.hasType(InternalTypeSystem.TYPE_SYSTEM.MAP())) {
                return value.asMap(v -> v).entrySet().stream().map(e -> new ParameterService.Parameter((String)e.getKey(), (Value)e.getValue())).toList();
            }
            String message = "Failed to evaluate parameters " + expression + ", got " + value;
            throw new ParameterService.ParameterEvaluationException(message);
        }

        private Optional<Value> evaluateOffline(String expression) {
            try {
                CypherCharStream charStream = new CypherCharStream(expression);
                Object value = new Cypher((ASTFactory)this.interpreter, ParameterException.FACTORY, (CharStream)charStream).Expression();
                return Optional.of(ShellParameterEvaluator.toDriverValue(value));
            }
            catch (Exception e) {
                log.warn("Failed to evaluate expression " + expression + " locally", e);
                return Optional.empty();
            }
        }

        private static Value toDriverValue(Object input) {
            if (input == null) {
                return NullValue.NULL;
            }
            if (input instanceof Map) {
                Map map = (Map)input;
                return new MapValue(map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ShellParameterEvaluator.toDriverValue(e.getValue()))));
            }
            if (input instanceof Iterable) {
                Iterable iterable = (Iterable)input;
                return Values.value(StreamSupport.stream(iterable.spliterator(), false).map(ShellParameterEvaluator::toDriverValue).toList());
            }
            if (input instanceof DurationValue) {
                DurationValue duration = (DurationValue)input;
                if (duration.getUnits().equals(List.of(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS))) {
                    long months = duration.get((TemporalUnit)ChronoUnit.MONTHS);
                    long days = duration.get((TemporalUnit)ChronoUnit.DAYS);
                    long seconds = duration.get((TemporalUnit)ChronoUnit.SECONDS);
                    int nanos = Math.toIntExact(duration.get((TemporalUnit)ChronoUnit.NANOS));
                    return Values.isoDuration((long)months, (long)days, (long)seconds, (int)nanos);
                }
                throw new ParameterService.ParameterEvaluationException("Paths not supported");
            }
            if (input instanceof PointValue) {
                PointValue point = (PointValue)input;
                int srid = point.getCoordinateReferenceSystem().getCode();
                double[] coords = point.getCoordinate().getCoordinate();
                if (coords.length == 2) {
                    return Values.point((int)srid, (double)coords[0], (double)coords[1]);
                }
                if (coords.length == 3) {
                    return Values.point((int)srid, (double)coords[0], (double)coords[1], (double)coords[2]);
                }
                throw new ParameterService.ParameterParsingException();
            }
            if (!(input instanceof Temporal)) {
                return Values.value((Object)input);
            }
            throw new ParameterService.ParameterParsingException();
        }

        private Value evaluateOnline(String expression) {
            try {
                String query = "RETURN " + expression + " AS `result`";
                return this.db.runCypher(query, ShellParameterService.this.parameters(), TransactionHandler.TransactionType.USER_TRANSPILED).map(r -> r.iterate().next().get("result")).orElseThrow();
            }
            catch (Exception e) {
                String message = "Failed to evaluate expression " + expression + ": " + e.getMessage();
                throw new ParameterService.ParameterEvaluationException(message, e);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ArrowParameterParser
    implements ParameterService.ParameterParser {
        private final List<Pattern> patterns = List.of(Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*)\\s*=>\\s*(?<value>.+)$"), Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):?\\s+(?<value>.+)$"), Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*=>\\s*(?<value>.+)$"), Pattern.compile("^\\s*(?<key>(`([^`])*`)+?):?\\s+(?<value>.+)$"));
        private final Pattern invalidPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):\\s*=>\\s*(?<value>.+)$");

        private ArrowParameterParser() {
        }

        @Override
        public ParameterService.RawParameters parse(String input) throws ParameterService.ParameterParsingException {
            if (this.invalidPattern.matcher(input).matches()) {
                throw new ParameterService.ParameterParsingException();
            }
            return this.patterns.stream().map(p -> p.matcher(input)).filter(Matcher::matches).findFirst().filter(m -> !m.group("key").isBlank() && !m.group("key").equals("``")).map(m -> new ParameterService.RawParameters(String.format("{%s: %s}", m.group("key"), m.group("value")))).orElse(null);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CypherMapParameterParser
    implements ParameterService.ParameterParser {
        private static final Pattern CYPHER_MAP_PATTERN = Pattern.compile("^\\s*\\{");

        private CypherMapParameterParser() {
        }

        @Override
        public ParameterService.RawParameters parse(String input) throws ParameterService.ParameterParsingException {
            if (CYPHER_MAP_PATTERN.matcher(input).find()) {
                return new ParameterService.RawParameters(input);
            }
            return null;
        }
    }
}

