/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\reb!\u0002\u0017.\u0003\u00031\u0004\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \t\u0011\u0015\u0003!\u0011!Q\u0001\n}B\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0011\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003R\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tO\u0002\u0011)\u0019!C\u0001Q\"Aq\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0001r\u0011!A\bA!A!\u0002\u0013\u0011\b\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0001>\t\u0013\u0005\u001d\u0001A!A!\u0002\u0013Y\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\n\u0003?\u0001!\u0019!C\t\u0003CA\u0001\"a\r\u0001A\u0003%\u00111\u0005\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003oA\u0001\"a\u0010\u0001A\u0003%\u0011\u0011\b\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007B\u0001\"!!\u0001A\u0003%\u0011Q\t\u0005\n\u0003\u0007\u0003!\u0019!C\u0005\u0003\u000bC\u0001\"!$\u0001A\u0003%\u0011q\u0011\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011%\t)\u000fAI\u0001\n\u0003\t9\u000fC\u0004\u0002\u0010\u0002!\t!!@\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!I!\u0011\b\u0001\u0012\u0002\u0013\u0005\u0011q\u001d\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011Y\b\u0001C\u0005\u0005{BqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u0003@\u0002!IA!1\t\u000f\t=\u0007\u0001\"\u0001\u0003R\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bw\u0001\u0011%!q^\u0004\b\u0007?i\u0003\u0012AB\u0011\r\u0019aS\u0006#\u0001\u0004$!9\u0011\u0011B\u0014\u0005\u0002\r\u0015\u0002\"CB\u0014O\t\u0007I\u0011AB\u0015\u0011!\u0019\td\nQ\u0001\n\r-\u0002\"CB\u001aOE\u0005I\u0011AB\u001b\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u00180\u0003!Ig\u000e^3s]\u0006d'B\u0001\u00192\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011!gM\u0001\u0006]\u0016|GG\u001b\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\r-,'O\\3m\u0013\t!\u0015IA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!aS\u0019\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002N\u0015\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t\u0011\u000b\u0005\u0002S+6\t1K\u0003\u0002U[\u00059AO]1dS:<\u0017B\u0001,T\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003\u0019\u0019wN\u001c4jOV\t!\f\u0005\u0002\\;6\tAL\u0003\u0002Y[%\u0011a\f\u0018\u0002\u0014\u0007f\u0004\b.\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u00039i\u0017m\u001d;fe\u000e{W\u000e]5mKJ,\u0012A\u0019\t\u0003G\u0012l\u0011!L\u0005\u0003K6\u0012a\"T1ti\u0016\u00148i\\7qS2,'/A\bnCN$XM]\"p[BLG.\u001a:!\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0017\u0002\u000b\r\f7\r[3\n\u00059\\'!E\"za\",'/U;fef\u001c\u0015m\u00195fg\u0006a\u0011/^3ss\u000e\u000b7\r[3tA\u0005YAn\\4Qe>4\u0018\u000eZ3s+\u0005\u0011\bCA:w\u001b\u0005!(BA;2\u0003\u001dawnZ4j]\u001eL!a\u001e;\u0003'%sG/\u001a:oC2dun\u001a)s_ZLG-\u001a:\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\u0002\u000b\rdwnY6\u0016\u0003m\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\u0005\u0011\u0001\u00026bm\u0006L1!!\u0002~\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u00051A(\u001b8jiz\"\"#!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001eA\u00111\r\u0001\u0005\u0006{E\u0001\ra\u0010\u0005\u0006\rF\u0001\r\u0001\u0013\u0005\u0006\u001fF\u0001\r!\u0015\u0005\u00061F\u0001\rA\u0017\u0005\u0006AF\u0001\rA\u0019\u0005\u0006OF\u0001\r!\u001b\u0005\u0006aF\u0001\rA\u001d\u0005\bsF\u0001\n\u00111\u0001|\u0003q!WMZ1vYR\fV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J,\"!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005)\u0011/^3ss*\u0019\u0011QF!\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003c\t9CA\u000bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\u0002;\u0011,g-Y;miF+XM]=Fq\u0016\u001cW\u000f^5p]6{g.\u001b;pe\u0002\n\u0011\u0002\u001d:f!\u0006\u00148/\u001a:\u0016\u0005\u0005e\u0002cA2\u0002<%\u0019\u0011QH\u0017\u0003!\r\u000b7\r[5oOB\u0013X\rU1sg\u0016\u0014\u0018A\u00039sKB\u000b'o]3sA\u0005Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0005\u0005\u0015\u0003cB2\u0002H\u0005-\u00131P\u0005\u0004\u0003\u0013j#AC)vKJL8)Y2iKB1\u0011QJA5\u0003_rA!a\u0014\u0002f9!\u0011\u0011KA2\u001d\u0011\t\u0019&!\u0019\u000f\t\u0005U\u0013q\f\b\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001\u001a4\u0013\t\u0001\u0014'\u0003\u0002/_%\u0019\u0011qM\u0017\u0002\u0015E+XM]=DC\u000eDW-\u0003\u0003\u0002l\u00055$\u0001C\"bG\",7*Z=\u000b\u0007\u0005\u001dT\u0006\u0005\u0003\u0002r\u0005]dbA2\u0002t%\u0019\u0011QO\u0017\u0002\u0015%s\u0007/\u001e;Rk\u0016\u0014\u00180\u0003\u0003\u0002l\u0005e$bAA;[A\u00191-! \n\u0007\u0005}TFA\bFq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005\u001d\u0005cA2\u0002\n&\u0019\u00111R\u0017\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0002\u001bM\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:!\u0003\u001d)\u00070Z2vi\u0016$\u0002#a%\u0002\u001a\u0006-\u0016qXAe\u0003'\f9.!9\u0011\t\u0005\u0015\u0012QS\u0005\u0005\u0003/\u000b9C\u0001\bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8\t\u000f\u0005%\"\u00041\u0001\u0002\u001cB!\u0011QTAS\u001d\u0011\ty*!)\u0011\u0007\u0005]\u0013(C\u0002\u0002$f\na\u0001\u0015:fI\u00164\u0017\u0002BAT\u0003S\u0013aa\u0015;sS:<'bAARs!9\u0011Q\u0016\u000eA\u0002\u0005=\u0016A\u00029be\u0006l7\u000f\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u000fYL'\u000f^;bY*\u0019\u0011\u0011X\u0019\u0002\rY\fG.^3t\u0013\u0011\ti,a-\u0003\u00115\u000b\u0007OV1mk\u0016Dq!!1\u001b\u0001\u0004\t\u0019-A\u0004d_:$X\r\u001f;\u0011\t\u0005\u0015\u0012QY\u0005\u0005\u0003\u000f\f9C\u0001\u000bUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0017T\u0002\u0019AAg\u0003\u001d\u0001(o\u001c4jY\u0016\u00042\u0001OAh\u0013\r\t\t.\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\t)N\u0007a\u0001\u0003\u001b\f1\u0002\u001d:f!>\u0004X\u000f\\1uK\"9\u0011\u0011\u001c\u000eA\u0002\u0005m\u0017AC:vEN\u001c'/\u001b2feB!\u0011QEAo\u0013\u0011\ty.a\n\u0003\u001fE+XM]=Tk\n\u001c8M]5cKJD\u0011\"a9\u001b!\u0003\u0005\r!a\t\u0002\u000f5|g.\u001b;pe\u0006\tR\r_3dkR,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005%(\u0006BA\u0012\u0003W\\#!!<\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oL\u0014AC1o]>$\u0018\r^5p]&!\u00111`Ay\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0011\u0003'\u000byPa\u0002\u0003\n\t-!Q\u0002B\u000f\u0005CAq!!\u000b\u001d\u0001\u0004\u0011\t\u0001E\u0002d\u0005\u0007I1A!\u0002.\u0005A1U\u000f\u001c7z!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010C\u0004\u0002.r\u0001\r!a,\t\u000f\u0005\u0005G\u00041\u0001\u0002D\"9\u0011Q\u001b\u000fA\u0002\u00055\u0007b\u0002B\b9\u0001\u0007!\u0011C\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!qC\u0017\u0002\u000fI,h\u000e^5nK&!!1\u0004B\u000b\u0005=Ie\u000e];u\t\u0006$\u0018m\u0015;sK\u0006l\u0007b\u0002B\u00109\u0001\u0007\u00111E\u0001\rcV,'/_'p]&$xN\u001d\u0005\b\u00033d\u0002\u0019AAn\u0003=)\u00070Z2vi\u0016\u001cVOY9vKJLHCEAJ\u0005O\u0011ICa\u000b\u0003.\tE\"1\u0007B\u001b\u0005oAq!!\u000b\u001e\u0001\u0004\tY\nC\u0004\u0002.v\u0001\r!a,\t\u000f\u0005\u0005W\u00041\u0001\u0002D\"9!qF\u000fA\u0002\u00055\u0017\u0001E5t\u001fV$XM]7pgR\fV/\u001a:z\u0011\u001d\tY-\ba\u0001\u0003\u001bDq!!6\u001e\u0001\u0004\ti\rC\u0004\u0002Zv\u0001\r!a7\t\u0013\u0005\rX\u0004%AA\u0002\u0005\r\u0012!G3yK\u000e,H/Z*vEF,XM]=%I\u00164\u0017-\u001e7uIa\nqa\u00197pg&tw-\u0006\u0003\u0003@\t\u001dCC\u0002B!\u0005G\u0012)\u0007\u0006\u0003\u0003D\te\u0003\u0003\u0002B#\u0005\u000fb\u0001\u0001B\u0004\u0003J}\u0011\rAa\u0013\u0003\u0003Q\u000bBA!\u0014\u0003TA\u0019\u0001Ha\u0014\n\u0007\tE\u0013HA\u0004O_RD\u0017N\\4\u0011\u0007a\u0012)&C\u0002\u0003Xe\u00121!\u00118z\u0011!\u0011Yf\bCA\u0002\tu\u0013\u0001B2pI\u0016\u0004R\u0001\u000fB0\u0005\u0007J1A!\u0019:\u0005!a$-\u001f8b[\u0016t\u0004bBAa?\u0001\u0007\u00111\u0019\u0005\b\u0005Oz\u0002\u0019\u0001B5\u0003)!(/Y2f\u000bZ,g\u000e\u001e\t\u0005\u0005W\u0012)H\u0004\u0003\u0003n\tEd\u0002BA(\u0005_J!\u0001V\u0017\n\u0007\tM4+A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa\u001e\u0003z\t)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001B:'\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0017\u0003'\u0013yHa\"\u0003\n\n-%Q\u0012BH\u0005#\u0013\u0019J!&\u0003\u0018\"9\u0011\u0011\u0006\u0011A\u0002\t\u0005\u0005cA2\u0003\u0004&\u0019!QQ\u0017\u0003\u0015%s\u0007/\u001e;Rk\u0016\u0014\u0018\u0010C\u0004\u0002.\u0002\u0002\r!a,\t\u000f\u0005\u0005\u0007\u00051\u0001\u0002D\"9!q\u0006\u0011A\u0002\u00055\u0007bBAkA\u0001\u0007\u0011Q\u001a\u0005\b\u0005\u001f\u0001\u0003\u0019\u0001B\t\u0011\u001d\u0011y\u0002\ta\u0001\u0003GAaa\u0014\u0011A\u0002\t%\u0004bBAmA\u0001\u0007\u00111\u001c\u0005\b\u00053\u0003\u0003\u0019\u0001BN\u0003Iqw\u000e^5gS\u000e\fG/[8o\u0019><w-\u001a:\u0011\t\tu%1U\u0007\u0003\u0005?S1A!).\u0003\u0011)H/\u001b7\n\t\t\u0015&q\u0014\u0002\u001b\u0013:$XM\u001d8bY:{G/\u001b4jG\u0006$\u0018n\u001c8M_\u001e<WM]\u0001$G>l\u0007/\u001b7fe^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]>\u0003H/[8o)1\u0011YK!-\u00036\n]&1\u0018B_!\u0015\u0019'QVA>\u0013\r\u0011y+\f\u0002$\u0007>l\u0007/\u001b7fe^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]>\u0003H/[8o\u0011\u001d\u0011\u0019,\ta\u0001\u0005\u0003\u000b!\"\u001b8qkR\fV/\u001a:z\u0011\u0019y\u0015\u00051\u0001\u0003j!9!\u0011X\u0011A\u0002\u0005\r\u0017\u0001\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0002.\u0006\u0002\r!a,\t\u000f\te\u0015\u00051\u0001\u0003\u001c\u0006aq-\u001a;Pe\u000e{W\u000e]5mKRa\u00111\u0010Bb\u0005\u000b\u0014IMa3\u0003N\"9\u0011\u0011\u0019\u0012A\u0002\u0005\r\u0007b\u0002BdE\u0001\u0007!\u0011Q\u0001\u0012S:LG/[1m\u0013:\u0004X\u000f^)vKJL\bBB(#\u0001\u0004\u0011I\u0007C\u0004\u0002.\n\u0002\r!a,\t\u000f\te%\u00051\u0001\u0003\u001c\u0006\u00012\r\\3beF+XM]=DC\u000eDWm\u001d\u000b\u0003\u0005'\u00042\u0001\u000fBk\u0013\r\u00119.\u000f\u0002\u0005\u0019>tw-\u0001\nhKR\u001c\u0015\u0010\u001d5fe\u001a+hn\u0019;j_:\u001cXC\u0001Bo!\u0019\u0011yNa9\u0003h6\u0011!\u0011\u001d\u0006\u0004\u0005C{\u0018\u0002\u0002Bs\u0005C\u0014A\u0001T5tiB!\u0011Q\u0005Bu\u0013\u0011\u0011Y/a\n\u0003'\u0019+hn\u0019;j_:LeNZ8s[\u0006$\u0018n\u001c8\u0002\u001f\rDWmY6QCJ\fW.\u001a;feN$\u0002B!=\u0003x\u000e\u00051Q\u0001\t\u0004q\tM\u0018b\u0001B{s\t!QK\\5u\u0011\u001d\u0011I0\na\u0001\u0005w\f1\"];fef\u0004\u0016M]1ngB)\u0001H!@\u0002\u001c&\u0019!q`\u001d\u0003\u000b\u0005\u0013(/Y=\t\u000f\r\rQ\u00051\u0001\u00020\u0006Yq-\u001b<f]B\u000b'/Y7t\u0011\u001d\u00199!\na\u0001\u0003_\u000bq\"\u001a=ue\u0006\u001cG/\u001a3QCJ\fWn\u001d\u0015\u0006K\r-1Q\u0004\t\u0006q\r51\u0011C\u0005\u0004\u0007\u001fI$A\u0002;ie><8\u000f\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\r\u00199\"M\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\u0018\u0002BB\u000e\u0007+\u0011!\u0004U1sC6,G/\u001a:O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u001c#a!\u0005\u0002\u001f\u0015CXmY;uS>tWI\\4j]\u0016\u0004\"aY\u0014\u0014\u0005\u001d:DCAB\u0011\u0003M\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#T+\t\u0019Y\u0003E\u00029\u0007[I1aa\f:\u0005\rIe\u000e^\u0001\u0015!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u00199DK\u0002|\u0003W\u0004")
public abstract class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params, notificationLogger);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().queryOptions().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.planDescriptionSupplier());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(initialInputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw new ParameterNotFoundException("Expected parameter(s): " + Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "));
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

