/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import java.util.Map;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class JoltRelationship {
    private final long id;
    private final String elementId;
    private final long startNodeId;
    private final String startNodeElementId;
    private final long endNodeId;
    private final String endNodeElementId;
    private final RelationshipType relationshipType;
    private final Map<String, Object> properties;

    private JoltRelationship(String elementId, long id, String startNodeElementId, long startNodeId, RelationshipType relationshipType, String endNodeElementId, long endNodeId, Map<String, Object> properties) {
        this.elementId = elementId;
        this.id = id;
        this.startNodeElementId = startNodeElementId;
        this.startNodeId = startNodeId;
        this.endNodeElementId = endNodeElementId;
        this.endNodeId = endNodeId;
        this.relationshipType = relationshipType;
        this.properties = properties;
    }

    public static JoltRelationship fromRelationshipReversed(Relationship relationship) {
        return new JoltRelationship(relationship.getElementId(), relationship.getId(), relationship.getEndNode().getElementId(), relationship.getEndNodeId(), relationship.getType(), relationship.getStartNode().getElementId(), relationship.getStartNodeId(), relationship.getAllProperties());
    }

    public RelationshipType getType() {
        return this.relationshipType;
    }

    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.elementId;
    }

    public long getStartNodeId() {
        return this.startNodeId;
    }

    public String getStartNodeElementId() {
        return this.startNodeElementId;
    }

    public long getEndNodeId() {
        return this.endNodeId;
    }

    public String getEndNodeElementId() {
        return this.endNodeElementId;
    }

    public Map<String, Object> getAllProperties() {
        return this.properties;
    }
}

