/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.IndexSizes;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class IndexChecker<Record extends PrimitiveRecord>
implements Checker {
    private static final String INDEX_CHECKER_TAG = "IndexChecker";
    private static final String CONSISTENCY_INDEX_ENTITY_CHECK_TAG = "consistencyIndexEntityCheck";
    private static final String CONSISTENCY_INDEX_CACHER_TAG = "consistencyIndexCacher";
    private static final int INDEX_CACHING_PROGRESS_FACTOR = 3;
    static final int NUM_INDEXES_IN_CACHE = 5;
    private static final int CHECKSUM_MASK = Short.MAX_VALUE;
    private static final int IN_USE_MASK = 32768;
    private static final int CHECKSUM_SIZE = 15;
    private static final int IN_USE_BIT = 1;
    private static final int TOTAL_SIZE = 16;
    private final EntityType entityType;
    private final ConsistencyReport.Reporter reporter;
    protected final CheckerContext context;
    private final IndexAccessors indexAccessors;
    private final CacheAccess cacheAccess;
    private final ProgressListener cacheProgress;
    private final ProgressListener scanProgress;
    private final List<IndexDescriptor> indexes;

    IndexChecker(CheckerContext context, EntityType entityType, String entityName) {
        this.indexAccessors = context.indexAccessors;
        this.context = context;
        this.entityType = entityType;
        this.reporter = context.reporter;
        this.cacheAccess = context.cacheAccess;
        this.indexes = context.indexSizes.largeIndexes(entityType);
        long totalSize = this.indexes.stream().mapToLong(context.indexSizes::getEstimatedIndexSize).sum();
        int rounds = (this.indexes.size() - 1) / 5 + 1;
        this.scanProgress = context.roundInsensitiveProgressReporter(this, entityName + " index checking", (long)rounds * this.highId());
        this.cacheProgress = context.roundInsensitiveProgressReporter(this, entityName + " index caching", totalSize / 3L);
    }

    abstract CommonAbstractStore<Record, ?> store();

    abstract long highId();

    abstract Record getEntity(StoreCursors var1, long var2);

    abstract int[] getEntityTokens(CheckerContext var1, StoreCursors var2, Record var3, RecordReader<DynamicRecord> var4);

    abstract RecordReader<DynamicRecord> additionalEntityTokenReader(CursorContext var1);

    abstract void reportEntityNotInUse(ConsistencyReport.IndexConsistencyReport var1, Record var2);

    abstract void reportIndexedIncorrectValues(ConsistencyReport.IndexConsistencyReport var1, Record var2, Object[] var3);

    abstract void reportIndexedWhenShouldNot(ConsistencyReport.IndexConsistencyReport var1, Record var2);

    abstract ConsistencyReport.PrimitiveConsistencyReport getReport(Record var1, ConsistencyReport.Reporter var2);

    private ConsistencyReport.PrimitiveConsistencyReport getReport(Record cursor) {
        return this.getReport(cursor, this.reporter);
    }

    @Override
    public void check(LongRange entityIdRange, boolean firstRange, boolean lastRange) throws Exception {
        this.cacheAccess.setCacheSlotSizesAndClear(16, 16, 16, 16, 16);
        ArrayList<IndexContext> indexesToCheck = new ArrayList<IndexContext>();
        try (CursorContext indexChecker = this.context.contextFactory.create(INDEX_CHECKER_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, indexChecker);){
            for (int i = 0; i < this.indexes.size() && !this.context.isCancelled(); ++i) {
                boolean canFitMoreAndIsNotLast;
                IndexContext index = new IndexContext(this.indexes.get(i), i % 5);
                indexesToCheck.add(index);
                this.cacheIndex(index, entityIdRange, firstRange, indexChecker, (StoreCursors)storeCursors);
                boolean isLastIndex = i == this.indexes.size() - 1;
                boolean bl = canFitMoreAndIsNotLast = !isLastIndex && index.cacheSlotOffset != 4;
                if (canFitMoreAndIsNotLast || this.context.isCancelled()) continue;
                this.checkVsEntities(indexesToCheck, entityIdRange);
                indexesToCheck = new ArrayList();
                this.cacheAccess.clearCache();
            }
        }
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.checkIndexes() && !this.indexes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIndex(IndexContext index, LongRange entityIdRange, boolean firstRange, CursorContext cursorContext, StoreCursors storeCursors) throws Exception {
        IndexAccessor accessor = this.indexAccessors.accessorFor(index.descriptor);
        IndexEntriesReader[] partitions = accessor.newAllEntriesValueReader(this.context.execution.getNumberOfThreads(), cursorContext);
        try {
            int i;
            Value[][] firstValues = new Value[partitions.length][];
            Value[][] lastValues = new Value[partitions.length][];
            long[] firstEntityIds = new long[partitions.length];
            long[] lastEntityIds = new long[partitions.length];
            ParallelExecution.ThrowingRunnable[] workers = new ParallelExecution.ThrowingRunnable[partitions.length];
            for (i = 0; i < partitions.length; ++i) {
                IndexEntriesReader partition = partitions[i];
                int slot = i;
                workers[i] = () -> {
                    int lastChecksum = 0;
                    int progressPart = 0;
                    CacheAccess.Client client = this.cacheAccess.client();
                    try (CursorContext context = this.context.contextFactory.create(CONSISTENCY_INDEX_CACHER_TAG);
                         CachedStoreCursors localStoreCursors = new CachedStoreCursors(this.context.neoStores, context);
                         ProgressListener localCacheProgress = this.cacheProgress.threadLocalReporter();){
                        while (partition.hasNext() && !this.context.isCancelled()) {
                            long entityId = partition.next();
                            if (!entityIdRange.isWithinRangeExclusiveTo(entityId)) {
                                if (firstRange && entityId >= this.highId()) {
                                    this.reportEntityNotInUse(this.reporter.forIndexEntry(new IndexEntry(index.descriptor, this.context.tokenNameLookup, entityId)), this.getEntity((StoreCursors)localStoreCursors, entityId));
                                    continue;
                                }
                                if (!firstRange || !index.descriptor.isUnique() || !index.hasValues) continue;
                                Value[] indexedValues = partition.values();
                                int checksum = IndexChecker.checksum(indexedValues);
                                assert (checksum <= Short.MAX_VALUE);
                                lastChecksum = this.verifyUniquenessInPartition(index, firstValues, lastValues, firstEntityIds, lastEntityIds, slot, lastChecksum, localStoreCursors, entityId, indexedValues, checksum);
                                continue;
                            }
                            int data = 32768;
                            if (index.hasValues) {
                                Value[] indexedValues = partition.values();
                                int checksum = IndexChecker.checksum(indexedValues);
                                assert (checksum <= Short.MAX_VALUE);
                                data |= checksum;
                                if (firstRange && index.descriptor.isUnique()) {
                                    lastChecksum = this.verifyUniquenessInPartition(index, firstValues, lastValues, firstEntityIds, lastEntityIds, slot, lastChecksum, localStoreCursors, entityId, indexedValues, checksum);
                                }
                            }
                            client.putToCacheSingle(entityId, index.cacheSlotOffset, data);
                            if (++progressPart != 3) continue;
                            localCacheProgress.add(1L);
                            progressPart = 0;
                        }
                    }
                };
            }
            this.context.execution.run("Cache index", workers);
            if (firstRange && index.descriptor.isUnique() && !this.context.isCancelled()) {
                for (i = 0; i < partitions.length - 1; ++i) {
                    Object[] left = lastValues[i];
                    Object[] right = firstValues[i + 1];
                    if (left == null || right == null || !Arrays.equals(left, right)) continue;
                    long leftEntityId = lastEntityIds[i];
                    long rightEntityId = firstEntityIds[i + 1];
                    this.getReport(this.getEntity(storeCursors, leftEntityId)).uniqueIndexNotUnique(index.descriptor, left, rightEntityId);
                }
            }
        }
        finally {
            IOUtils.closeAll((AutoCloseable[])partitions);
        }
    }

    private int verifyUniquenessInPartition(IndexContext index, Value[][] firstValues, Value[][] lastValues, long[] firstEntityIds, long[] lastEntityIds, int slot, int lastChecksum, CachedStoreCursors localStoreCursors, long entityId, Value[] indexedValues, int checksum) {
        if (firstValues[slot] == null) {
            firstValues[slot] = indexedValues;
            firstEntityIds[slot] = entityId;
        }
        if (lastValues[slot] != null && lastChecksum == checksum && Arrays.equals(lastValues[slot], indexedValues)) {
            this.getReport(this.getEntity((StoreCursors)localStoreCursors, entityId)).uniqueIndexNotUnique(index.descriptor, indexedValues, lastEntityIds[slot]);
        }
        lastValues[slot] = indexedValues;
        lastEntityIds[slot] = entityId;
        return checksum;
    }

    private void checkVsEntities(List<IndexContext> indexes, LongRange entityIdRange) throws Exception {
        ParallelExecution execution = this.context.execution;
        execution.run(this.getClass().getSimpleName() + "-checkVsEntities", execution.partition(entityIdRange, (from, to, last) -> () -> this.checkVsEntities(indexes, from, to)));
    }

    private void checkVsEntities(List<IndexContext> indexes, long fromEntityId, long toEntityId) {
        CheckerContext noReportingContext = this.context.withoutReporting();
        try (CursorContext cursorContext = this.context.contextFactory.create(CONSISTENCY_INDEX_ENTITY_CHECK_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);
             RecordReader<Record> entityReader = new RecordReader<Record>(this.store(), true, cursorContext);
             RecordReader<DynamicRecord> entityTokenReader = this.additionalEntityTokenReader(cursorContext);
             SafePropertyChainReader propertyReader = new SafePropertyChainReader(noReportingContext, cursorContext);
             ProgressListener localScanProgress = this.scanProgress.threadLocalReporter();){
            IntObjectHashMap<Value> allValues = new IntObjectHashMap<Value>();
            CacheAccess.Client client = this.cacheAccess.client();
            int numberOfIndexes = indexes.size();
            for (long entityId = fromEntityId; entityId < toEntityId && !this.context.isCancelled(); ++entityId) {
                PrimitiveRecord entityRecord = (PrimitiveRecord)entityReader.read(entityId);
                if (!entityRecord.inUse()) {
                    for (int i = 0; i < numberOfIndexes; ++i) {
                        boolean isInIndex;
                        boolean bl = isInIndex = (client.getFromCache(entityId, i) & 0x8000L) != 0L;
                        if (!isInIndex) continue;
                        this.reportEntityNotInUse(this.reporter.forIndexEntry(new IndexEntry(indexes.get((int)i).descriptor, this.context.tokenNameLookup, entityId)), this.getEntity((StoreCursors)storeCursors, entityId));
                    }
                } else {
                    boolean propertyChainRead;
                    int[] entityTokens = this.getEntityTokens(noReportingContext, (StoreCursors)storeCursors, entityRecord, entityTokenReader);
                    allValues = RecordLoading.lightReplace(allValues);
                    boolean bl = propertyChainRead = entityTokens != null && propertyReader.read((MutableIntObjectMap<Value>)allValues, entityRecord, record -> this.getReport(record, noReportingContext.reporter), (StoreCursors)storeCursors);
                    if (propertyChainRead) {
                        for (int i = 0; i < numberOfIndexes; ++i) {
                            boolean entityShouldBeInIndex;
                            IndexContext index = indexes.get(i);
                            IndexDescriptor descriptor = index.descriptor;
                            long cachedValue = client.getFromCache(entityId, i);
                            boolean entityIsInIndex = (cachedValue & 0x8000L) != 0L;
                            Value[] values = RecordLoading.entityIntersectionWithSchema(entityTokens, allValues, descriptor);
                            boolean bl2 = entityShouldBeInIndex = values != null;
                            if (descriptor.getIndexType() == IndexType.FULLTEXT && !entityShouldBeInIndex && entityIsInIndex) {
                                int[] indexPropertyKeys = descriptor.schema().getPropertyIds();
                                Object[] noValues = new Value[indexPropertyKeys.length];
                                Arrays.fill(noValues, Values.NO_VALUE);
                                long docsWithNoneOfProperties = this.indexAccessors.readers().reader(descriptor).countIndexedEntities(entityId, cursorContext, indexPropertyKeys, (Value[])noValues);
                                if (docsWithNoneOfProperties == 1L) continue;
                                this.reportIndexedWhenShouldNot(this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)), this.getEntity((StoreCursors)storeCursors, entityId));
                                continue;
                            }
                            if (entityShouldBeInIndex && !entityIsInIndex) {
                                this.getReport(this.getEntity((StoreCursors)storeCursors, entityId)).notIndexed(descriptor, Values.asObjects((Value[])values));
                                continue;
                            }
                            if (entityShouldBeInIndex && entityIsInIndex && index.hasValues) {
                                int cachedChecksum = (int)cachedValue & Short.MAX_VALUE;
                                int actualChecksum = IndexChecker.checksum(values);
                                if (cachedChecksum == actualChecksum) continue;
                                this.reportIndexedIncorrectValues(this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)), this.getEntity((StoreCursors)storeCursors, entityId), Values.asObjects((Value[])values));
                                continue;
                            }
                            if (entityShouldBeInIndex || !entityIsInIndex) continue;
                            this.reportIndexedWhenShouldNot(this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)), this.getEntity((StoreCursors)storeCursors, entityId));
                        }
                    }
                }
                localScanProgress.add(1L);
            }
        }
    }

    public String toString() {
        return String.format("%s[entityType:%s,indexesToCheck:%d]", this.getClass().getSimpleName(), this.entityType, this.indexes.size());
    }

    private static int checksum(Value[] values) {
        int checksum = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                checksum ^= values[i].hashCode() * (i + 1);
            }
        }
        int twoByteChecksum = checksum >>> 16 ^ checksum & 0xFF;
        return twoByteChecksum & Short.MAX_VALUE;
    }

    private static class IndexContext {
        final IndexDescriptor descriptor;
        final int cacheSlotOffset;
        final boolean hasValues;

        IndexContext(IndexDescriptor descriptor, int cacheSlotOffset) {
            this.descriptor = descriptor;
            this.cacheSlotOffset = cacheSlotOffset;
            this.hasValues = IndexSizes.hasValues(descriptor);
        }
    }
}

