/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.stats.DetailLevel;
import org.neo4j.internal.batchimport.stats.GenericStatsProvider;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.io.ByteUnit;

public class MemoryUsageStatsProvider
extends GenericStatsProvider
implements Stat {
    private final MemoryStatsVisitor.Visitable[] users;

    public MemoryUsageStatsProvider(MemoryStatsVisitor.Visitable ... users) {
        this.users = users;
        this.add((Key)Keys.memory_usage, this);
    }

    public DetailLevel detailLevel() {
        return DetailLevel.IMPORTANT;
    }

    public long asLong() {
        GatheringMemoryStatsVisitor visitor = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : this.users) {
            user.acceptMemoryStatsVisitor((MemoryStatsVisitor)visitor);
        }
        return visitor.getHeapUsage() + visitor.getOffHeapUsage();
    }

    public String toString() {
        return ByteUnit.bytesToString((long)this.asLong());
    }
}

