/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class NodeSetFirstGroupStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private static final String SET_FIRST_GROUP_STEP_TAG = "setFirstGroupStep";
    private final int batchSize;
    private final ByteArray cache;
    private final NodeStore nodeStore;
    private final PageCursor nodeCursor;
    private final CursorContext cursorContext;
    private NodeRecord[] current;
    private int cursor;

    NodeSetFirstGroupStep(StageControl control, Configuration config, NodeStore nodeStore, ByteArray cache, CursorContextFactory contextFactory) {
        super(control, "FIRST", config, 1, contextFactory, new StatsProvider[0]);
        this.cache = cache;
        this.batchSize = config.batchSize();
        this.nodeStore = nodeStore;
        this.cursorContext = contextFactory.create(SET_FIRST_GROUP_STEP_TAG);
        this.nodeCursor = nodeStore.openPageCursorForReading(0L, this.cursorContext);
        this.newBatch();
    }

    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
    }

    private void newBatch() {
        this.current = new NodeRecord[this.batchSize];
        this.cursor = 0;
    }

    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, CursorContext cursorContext) {
        for (RelationshipGroupRecord group : batch) {
            long nodeId;
            if (!group.inUse() || this.cache.getByte(nodeId = group.getOwningNode(), 0) != 0) continue;
            this.cache.setByte(nodeId, 0, (byte)1);
            NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
            this.nodeStore.getRecordByCursor(nodeId, nodeRecord, RecordLoad.NORMAL, this.nodeCursor);
            nodeRecord.setNextRel(group.getId());
            nodeRecord.setDense(true);
            this.current[this.cursor++] = nodeRecord;
            if (this.cursor != this.batchSize) continue;
            sender.send((Object)this.current);
            this.newBatch();
        }
        this.control.recycle((Object)batch);
    }

    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
        if (this.cursor > 0) {
            sender.send((Object)this.current);
        }
    }

    public void close() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.cursorContext});
        super.close();
    }
}

