/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LockVerificationMonitor;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public interface CommandLockVerification {
    public static final CommandLockVerification IGNORE = commands -> {};

    public void verifySufficientlyLocked(Collection<StorageCommand> var1);

    public static class RealChecker
    implements CommandLockVerification {
        private final ResourceLocker locks;
        private final ReadableTransactionState txState;
        private final LockVerificationMonitor.StoreLoader loader;

        RealChecker(ResourceLocker locks, ReadableTransactionState txState, NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            this.locks = locks;
            this.txState = txState;
            this.loader = new LockVerificationMonitor.NeoStoresLoader(neoStores, schemaRuleAccess, storeCursors);
        }

        @Override
        public void verifySufficientlyLocked(Collection<StorageCommand> commands) {
            commands.forEach(this::verifySufficientlyLocked);
        }

        private void verifySufficientlyLocked(StorageCommand command) {
            if (command instanceof Command.NodeCommand) {
                this.verifyNodeSufficientlyLocked((Command.NodeCommand)command);
            } else if (command instanceof Command.RelationshipCommand) {
                this.verifyRelationshipSufficientlyLocked((Command.RelationshipCommand)command);
            } else if (command instanceof Command.RelationshipGroupCommand) {
                this.verifyRelationshipGroupSufficientlyLocked((Command.RelationshipGroupCommand)command);
            } else if (command instanceof Command.PropertyCommand) {
                this.verifyPropertySufficientlyLocked((Command.PropertyCommand)command);
            } else if (command instanceof Command.SchemaRuleCommand) {
                this.verifySchemaSufficientlyLocked((Command.SchemaRuleCommand)command);
            }
        }

        private void verifySchemaSufficientlyLocked(Command.SchemaRuleCommand command) {
            LockVerificationMonitor.assertSchemaLocked(this.locks, command.getSchemaRule(), ((SchemaRecord)command.before).inUse() ? command.before : command.after);
        }

        private void verifyPropertySufficientlyLocked(Command.PropertyCommand command) {
            PropertyRecord record;
            PropertyRecord propertyRecord = record = ((PropertyRecord)command.after).inUse() ? (PropertyRecord)command.after : (PropertyRecord)command.before;
            if (record.isNodeSet()) {
                if (!this.txState.nodeIsAddedInThisBatch(record.getNodeId())) {
                    this.assertLocked(record.getNodeId(), ResourceType.NODE, LockType.EXCLUSIVE, record);
                }
            } else if (record.isRelSet()) {
                if (!this.txState.relationshipIsAddedInThisBatch(record.getRelId())) {
                    this.assertLocked(record.getRelId(), ResourceType.RELATIONSHIP, LockType.EXCLUSIVE, record);
                }
            } else if (record.isSchemaSet()) {
                if (!((PropertyRecord)command.before).inUse() && ((PropertyRecord)command.after).inUse()) {
                    return;
                }
                LockVerificationMonitor.assertSchemaLocked(this.locks, this.loader.loadSchema(command.getSchemaRuleId()), record);
            }
        }

        private void verifyNodeSufficientlyLocked(Command.NodeCommand command) {
            long id = command.getKey();
            if (!this.txState.nodeIsAddedInThisBatch(id)) {
                this.assertLocked(id, ResourceType.NODE, LockType.EXCLUSIVE, command.after);
            }
            if (this.txState.nodeIsDeletedInThisBatch(id)) {
                this.assertLocked(id, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, LockType.EXCLUSIVE, command.after);
            }
        }

        private void verifyRelationshipSufficientlyLocked(Command.RelationshipCommand command) {
            LockVerificationMonitor.checkRelationship(this.txState, this.locks, this.loader, (RelationshipRecord)command.after);
            if (((RelationshipRecord)command.before).inUse()) {
                LockVerificationMonitor.assertRecordsEquals((RelationshipRecord)command.before, this.loader::loadRelationship);
            }
        }

        private void verifyRelationshipGroupSufficientlyLocked(Command.RelationshipGroupCommand command) {
            boolean deleted;
            long node = ((RelationshipGroupRecord)command.after).getOwningNode();
            if (!this.txState.nodeIsAddedInThisBatch(node)) {
                this.assertLocked(node, ResourceType.RELATIONSHIP_GROUP, LockType.EXCLUSIVE, command.after);
            }
            boolean bl = deleted = !((RelationshipGroupRecord)command.after).inUse();
            if (deleted) {
                this.assertLocked(node, ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, LockType.EXCLUSIVE, command.after);
            }
            if (((RelationshipGroupRecord)command.before).inUse()) {
                LockVerificationMonitor.assertRecordsEquals((RelationshipGroupRecord)command.before, this.loader::loadRelationshipGroup);
            }
        }

        private void assertLocked(long id, ResourceType resource, LockType type, AbstractBaseRecord record) {
            LockVerificationMonitor.assertLocked(this.locks, id, resource, type, record);
        }
    }
}

