/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CountsStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.storageengine.api.StorageEngineTransaction;

class CountsStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final CountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;

    CountsStoreTransactionApplierFactory(CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore) {
        this.countsStore = countsStore;
        this.groupDegreesStore = groupDegreesStore;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        return new CountsStoreTransactionApplier(this.countsStore, this.groupDegreesStore, transaction);
    }
}

