/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;

public class DirectRecordAccess<RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private final RecordStore<RECORD> store;
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final CursorType cursorType;
    private final Map<Long, DirectRecordProxy> batch = new HashMap<Long, DirectRecordProxy>();
    private final MutableInt changeCounter = new MutableInt();

    public DirectRecordAccess(RecordStore<RECORD> store, RecordAccess.Loader<RECORD, ADDITIONAL> loader, CursorContext cursorContext, CursorType cursorType, StoreCursors storeCursors) {
        this.store = store;
        this.loader = loader;
        this.cursorContext = cursorContext;
        this.cursorType = cursorType;
        this.storeCursors = storeCursors;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData, RecordLoad load) {
        DirectRecordProxy loaded = this.batch.get(key);
        if (loaded != null) {
            return loaded;
        }
        return this.proxy(key, this.loader.load(key, additionalData, load, (MemoryTracker)EmptyMemoryTracker.INSTANCE), additionalData, false, this.cursorContext);
    }

    private RecordAccess.RecordProxy<RECORD, ADDITIONAL> putInBatch(long key, DirectRecordProxy proxy) {
        DirectRecordProxy previous = this.batch.put(key, proxy);
        assert (previous == null);
        return proxy;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData, CursorContext cursorContext) {
        return this.proxy(key, this.loader.newUnused(key, additionalData, (MemoryTracker)EmptyMemoryTracker.INSTANCE), additionalData, true, cursorContext);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return this.batch.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }

    @Override
    public Collection<DirectRecordProxy> changes() {
        return this.batch.values();
    }

    private DirectRecordProxy proxy(long key, RECORD record, ADDITIONAL additionalData, boolean created, CursorContext cursorContext) {
        return new DirectRecordProxy(this, key, record, additionalData, created, cursorContext);
    }

    public void commit() {
        if (this.changeCounter.intValue() == 0) {
            return;
        }
        ArrayList<DirectRecordProxy> directRecordProxies = new ArrayList<DirectRecordProxy>(this.batch.values());
        directRecordProxies.sort((o1, o2) -> Long.compare(-o1.getKey(), o2.getKey()));
        try (PageCursor cursor = this.storeCursors.writeCursor(this.cursorType);){
            for (DirectRecordProxy proxy : directRecordProxies) {
                proxy.store(cursor);
            }
        }
        this.changeCounter.setValue(0);
        this.batch.clear();
    }

    private class DirectRecordProxy
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final long key;
        private final RECORD record;
        private final ADDITIONAL additionalData;
        private final CursorContext cursorContext;
        private boolean changed;
        private final boolean created;
        private RECORD before;
        final /* synthetic */ DirectRecordAccess this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        DirectRecordProxy(long record, RECORD created, ADDITIONAL cursorContext, boolean bl, CursorContext cursorContext2) {
            void additionalData;
            void key;
            this.this$0 = (DirectRecordAccess)l;
            this.key = key;
            this.record = record;
            this.additionalData = additionalData;
            this.cursorContext = cursorContext;
            if (created != false) {
                this.prepareChange();
            }
            this.created = created;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            this.prepareChange();
            return this.record;
        }

        private void prepareChange() {
            if (!this.changed) {
                this.changed = true;
                this.this$0.putInBatch(this.key, this);
                this.this$0.changeCounter.increment();
            }
        }

        @Override
        public RECORD forChangingData() {
            this.this$0.loader.ensureHeavy(this.record, this.this$0.storeCursors);
            this.prepareChange();
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.this$0.loader.ensureHeavy(this.record, this.this$0.storeCursors);
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.this$0.loader.copy(this.record, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
        }

        public String toString() {
            return ((AbstractBaseRecord)this.record).toString();
        }

        public void store(PageCursor pageCursor) {
            if (this.changed) {
                this.this$0.store.updateRecord(this.record, IdUpdateListener.IGNORE, pageCursor, this.cursorContext, this.this$0.storeCursors);
            }
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }
    }
}

