/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.internal.recordstorage.NodeContext;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;

class MappedNodeDataLookup
implements RelationshipCreator.NodeDataLookup {
    private final MutableLongObjectMap<NodeContext> contexts;
    private final RelationshipGroupGetter relGroupGetter;
    private final RecordAccessSet recordChanges;
    private final MemoryTracker memoryTracker;

    MappedNodeDataLookup(MutableLongObjectMap<NodeContext> contexts, RelationshipGroupGetter relGroupGetter, RecordAccessSet recordChanges, MemoryTracker memoryTracker) {
        this.contexts = contexts;
        this.relGroupGetter = relGroupGetter;
        this.recordChanges = recordChanges;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint(long nodeId, int type, int dir) {
        NodeContext.DenseContext context;
        NodeContext byNode = (NodeContext)this.contexts.get(nodeId);
        if (byNode != null && (context = byNode.denseContextIfExists(type)) != null) {
            return context.insertionPoint(dir);
        }
        return null;
    }

    @Override
    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long nodeId, int type, boolean create) {
        NodeContext nodeContext = (NodeContext)this.contexts.getIfAbsentPutWithKey(nodeId, (LongToObjectFunction & Serializable)n -> NodeContext.createNodeContext(this.recordChanges.getNodeRecords().getOrLoad(n, null), this.memoryTracker));
        NodeContext.DenseContext context = nodeContext.denseContext(type);
        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group = context.group();
        if (group == null) {
            RecordAccess.RecordProxy<NodeRecord, Object> nodeChange = this.recordChanges.getNodeRecords().getOrLoad(nodeId, null);
            group = create ? this.relGroupGetter.getOrCreateRelationshipGroup(nodeChange, type, this.recordChanges.getRelGroupRecords()) : this.relGroupGetter.getRelationshipGroup(nodeChange.forReadingLinkage(), type, this.recordChanges.getRelGroupRecords(), RelationshipGroupGetter.RelationshipGroupMonitor.EMPTY).group();
            context.setGroup(group);
        }
        return group;
    }

    @Override
    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long groupId) {
        RecordAccess.RecordProxy<RelationshipGroupRecord, Object> groupProxy = this.recordChanges.getRelGroupRecords().getOrLoad(groupId, null);
        RelationshipGroupRecord group = groupProxy.forReadingData();
        NodeContext nodeContext = (NodeContext)this.contexts.getIfAbsentPutWithKey(group.getOwningNode(), (LongToObjectFunction & Serializable)n -> NodeContext.createNodeContext(this.recordChanges.getNodeRecords().getOrLoad(n, null), this.memoryTracker));
        NodeContext.DenseContext context = nodeContext.denseContext(group.getType());
        context.setGroup(groupProxy);
        return groupProxy;
    }
}

