/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.Path;
import java.util.function.Function;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.batchimport.NodeCountsStage;
import org.neo4j.internal.batchimport.RelationshipCountsStage;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class CountsComputer
implements CountsBuilder {
    private final NeoStores neoStores;
    private final NodeStore nodes;
    private final RelationshipStore relationships;
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final long lastCommittedTransactionId;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final NumberArrayFactory numberArrayFactory;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;

    public CountsComputer(NeoStores stores, PageCache pageCache, CursorContextFactory contextFactory, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, InternalLog log) {
        this(stores, stores.getMetaDataStore().getLastCommittedTransactionId(), pageCache, contextFactory, databaseLayout, memoryTracker, log);
    }

    public CountsComputer(NeoStores stores, long lastCommittedTransactionId, PageCache pageCache, CursorContextFactory contextFactory, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, InternalLog log) {
        this(stores, lastCommittedTransactionId, stores.getNodeStore(), stores.getRelationshipStore(), (int)stores.getLabelTokenStore().getIdGenerator().getHighId(), (int)stores.getRelationshipTypeTokenStore().getIdGenerator().getHighId(), NumberArrayFactories.auto((PageCache)pageCache, (CursorContextFactory)contextFactory, (Path)databaseLayout.databaseDirectory(), (boolean)true, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (InternalLog)log, (String)databaseLayout.getDatabaseName()), ProgressMonitorFactory.NONE, contextFactory, memoryTracker);
    }

    public CountsComputer(NeoStores stores, long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId, NumberArrayFactory numberArrayFactory, ProgressMonitorFactory progressMonitorFactory, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        this.neoStores = stores;
        this.lastCommittedTransactionId = lastCommittedTransactionId;
        this.nodes = nodes;
        this.relationships = relationships;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.numberArrayFactory = numberArrayFactory;
        this.progressMonitorFactory = progressMonitorFactory;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
    }

    public void initialize(CountsUpdater countsUpdater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.hasNotEmptyNodesOrRelationshipsStores(cursorContext)) {
            long total = this.nodes.getHighestPossibleIdInUse(cursorContext) + this.relationships.getHighestPossibleIdInUse(cursorContext);
            try (ProgressListener progress = this.progressMonitorFactory.singlePart("CountsUpdater", total);){
                this.populateCountStore(countsUpdater, progress);
            }
        }
    }

    private boolean hasNotEmptyNodesOrRelationshipsStores(CursorContext cursorContext) {
        return this.nodes.getHighestPossibleIdInUse(cursorContext) != -1L || this.relationships.getHighestPossibleIdInUse(cursorContext) != -1L;
    }

    private void populateCountStore(CountsUpdater countsUpdater, ProgressListener progress) {
        try (NodeLabelsCache cache = new NodeLabelsCache(this.numberArrayFactory, this.nodes.getIdGenerator().getHighId(), this.highLabelId, this.memoryTracker);){
            Configuration configuration = Configuration.defaultConfiguration();
            Function<CursorContext, StoreCursors> storeCursorsFunction = cursorContext -> new CachedStoreCursors(this.neoStores, (CursorContext)cursorContext);
            ExecutionSupervisors.superviseDynamicExecution((Stage)new NodeCountsStage(configuration, cache, this.nodes, this.highLabelId, countsUpdater, progress, this.contextFactory, storeCursorsFunction, new StatsProvider[0]));
            ExecutionSupervisors.superviseDynamicExecution((Stage)new RelationshipCountsStage(configuration, cache, this.relationships, this.highLabelId, this.highRelationshipTypeId, countsUpdater, this.numberArrayFactory, progress, this.contextFactory, storeCursorsFunction, this.memoryTracker));
        }
    }

    public long lastCommittedTxId() {
        return this.lastCommittedTransactionId;
    }
}

