/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreType;

public class DynamicAllocatorProviders {
    public static DynamicAllocatorProvider nonTransactionalAllocator(NeoStores neoStores) {
        return new DetachedDynamicAllocatorProvider(neoStores);
    }

    private static class DetachedDynamicAllocatorProvider
    implements DynamicAllocatorProvider {
        private final StandardDynamicRecordAllocator[] dynamicAllocators = new StandardDynamicRecordAllocator[StoreType.STORE_TYPES.length];
        private final NeoStores neoStores;

        private DetachedDynamicAllocatorProvider(NeoStores neoStores) {
            this.neoStores = neoStores;
        }

        @Override
        public DynamicRecordAllocator allocator(StoreType type) {
            StandardDynamicRecordAllocator newAllocator;
            StandardDynamicRecordAllocator allocator = this.dynamicAllocators[type.ordinal()];
            if (allocator != null) {
                return allocator;
            }
            RecordStore recordStore = this.neoStores.getRecordStore(type);
            this.dynamicAllocators[type.ordinal()] = newAllocator = new StandardDynamicRecordAllocator(cursorContext -> recordStore.getIdGenerator().nextId(cursorContext), this.neoStores.getRecordStore(type).getRecordDataSize());
            return newAllocator;
        }
    }
}

