/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;

public class LabelIdArray {
    private LabelIdArray() {
    }

    static int[] concatAndSort(int[] existing, int additional) {
        LabelIdArray.assertNotContains(existing, additional);
        int[] result = new int[existing.length + 1];
        System.arraycopy(existing, 0, result, 0, existing.length);
        result[existing.length] = additional;
        Arrays.sort(result);
        return result;
    }

    private static void assertNotContains(int[] existingLabels, int labelId) {
        if (Arrays.binarySearch(existingLabels, labelId) >= 0) {
            throw new IllegalStateException("Label " + labelId + " already exists.");
        }
    }

    static int[] filter(int[] ids, int excludeId) {
        boolean found = false;
        int[] nArray = ids;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long id = nArray[i];
            if (id != (long)excludeId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Label " + excludeId + " not found.");
        }
        int[] result = new int[ids.length - 1];
        int writerIndex = 0;
        for (int id : ids) {
            if (id == excludeId) continue;
            result[writerIndex++] = id;
        }
        return result;
    }

    public static long[] prependNodeId(long nodeId, int[] labelIds) {
        long[] result = new long[labelIds.length + 1];
        result[0] = nodeId;
        for (int i = 0; i < labelIds.length; ++i) {
            result[i + 1] = labelIds[i];
        }
        return result;
    }

    public static int[] stripNodeId(long[] storedLongs) {
        long[] recordLabels = Arrays.copyOfRange(storedLongs, 1, storedLongs.length);
        int[] labelIds = new int[recordLabels.length];
        for (int i = 0; i < labelIds.length; ++i) {
            labelIds[i] = (int)recordLabels[i];
        }
        return labelIds;
    }
}

