/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.SchemaStore44Migration;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.token.TokenHolders;

public class SchemaStoreMigration {
    static SchemaStoreMigrator getSchemaStoreMigration(RecordFormats oldFormat, RecordDatabaseLayout directoryLayout, CursorContext cursorContext, boolean requiresPropertyMigration, boolean forceBtreeIndexesToRange, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer, FileSystemAbstraction fileSystem, CursorContextFactory contextFactory) throws IOException {
        ScanOnOpenReadOnlyIdGeneratorFactory srcIdGeneratorFactory = new ScanOnOpenReadOnlyIdGeneratorFactory();
        StoreFactory srcFactory = SchemaStoreMigration.createStoreFactory(directoryLayout, config, (IdGeneratorFactory)srcIdGeneratorFactory, pageCache, pageCacheTracer, fileSystem, oldFormat, contextFactory);
        if (!RecordStorageMigrator.need50Migration(oldFormat)) {
            List schemaRules;
            if (!requiresPropertyMigration) {
                return new SchemaStoreNoMigration();
            }
            try (NeoStores srcStore = srcFactory.openNeoStores(StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.PROPERTY, StoreType.PROPERTY_STRING, StoreType.PROPERTY_ARRAY, StoreType.SCHEMA);
                 CachedStoreCursors srcCursors = new CachedStoreCursors(srcStore, cursorContext);){
                TokenHolders srcTokenHolders = RecordStorageMigrator.createTokenHolders(srcStore, srcCursors);
                SchemaStorage schemaStorage = new SchemaStorage(srcStore.getSchemaStore(), srcTokenHolders);
                schemaRules = Iterables.asList(schemaStorage.getAll((StoreCursors)srcCursors));
            }
            return new SchemaStoreNewFamilyMigration(schemaRules);
        }
        return SchemaStore44Migration.getSchemaStore44Migrator(fileSystem, oldFormat, directoryLayout, cursorContext, requiresPropertyMigration, forceBtreeIndexesToRange, config, pageCache, pageCacheTracer, contextFactory, (IdGeneratorFactory)srcIdGeneratorFactory, srcFactory);
    }

    private static StoreFactory createStoreFactory(RecordDatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, FileSystemAbstraction fileSystem, RecordFormats formats, CursorContextFactory contextFactory) {
        return new StoreFactory((DatabaseLayout)databaseLayout, config, idGeneratorFactory, pageCache, pageCacheTracer, fileSystem, formats, (InternalLogProvider)NullLogProvider.getInstance(), contextFactory, true, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    static class SchemaStoreNoMigration
    implements SchemaStoreMigrator {
        SchemaStoreNoMigration() {
        }

        @Override
        public void assertCanMigrate() throws IllegalStateException {
        }

        @Override
        public void copyFilesInPreparationForMigration(FileSystemAbstraction fileSystem, RecordDatabaseLayout directoryLayout, RecordDatabaseLayout migrationLayout) {
        }

        @Override
        public void migrate(SchemaRuleMigrationAccess dstAccess, TokenHolders dstTokensHolders) {
        }
    }

    record SchemaStoreNewFamilyMigration(List<SchemaRule> rules) implements SchemaStoreMigrator
    {
        @Override
        public void assertCanMigrate() throws IllegalStateException {
        }

        @Override
        public void copyFilesInPreparationForMigration(FileSystemAbstraction fileSystem, RecordDatabaseLayout directoryLayout, RecordDatabaseLayout migrationLayout) throws IOException {
            List<DatabaseFile> databaseFiles = Arrays.asList(RecordDatabaseFile.PROPERTY_STORE, RecordDatabaseFile.PROPERTY_ARRAY_STORE, RecordDatabaseFile.PROPERTY_STRING_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordDatabaseFile.LABEL_TOKEN_STORE, RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
            StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.COPY, (FileSystemAbstraction)fileSystem, (DatabaseLayout)directoryLayout, (DatabaseLayout)migrationLayout, databaseFiles, (boolean)true, (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.SKIP);
        }

        @Override
        public void migrate(SchemaRuleMigrationAccess dstAccess, TokenHolders dstTokensHolders) throws KernelException {
            for (SchemaRule rule : this.rules) {
                dstAccess.writeSchemaRule(rule);
            }
        }
    }

    public static interface SchemaStoreMigrator {
        public void assertCanMigrate() throws IllegalStateException;

        public void copyFilesInPreparationForMigration(FileSystemAbstraction var1, RecordDatabaseLayout var2, RecordDatabaseLayout var3) throws IOException;

        public void migrate(SchemaRuleMigrationAccess var1, TokenHolders var2) throws KernelException;
    }
}

